/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.core.write;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.mina.core.future.DefaultWriteFutureEx;
import org.kaazing.mina.core.future.WriteFutureEx;
import org.kaazing.mina.core.write.WriteRequestEx;
import org.kaazing.mina.netty.util.threadlocal.VicariousThreadLocal;

public class DefaultWriteRequestEx
implements WriteRequestEx {
    private static final WriteFutureEx UNUSED_FUTURE = new WriteFutureEx(){

        @Override
        public boolean isWritten() {
            return false;
        }

        @Override
        public void setWritten() {
        }

        @Override
        public IoSession getSession() {
            return null;
        }

        @Override
        public void join() {
        }

        @Override
        public boolean join(long timeoutInMillis) {
            return true;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public boolean isResetable() {
            return false;
        }

        @Override
        public void reset(IoSession session) {
            throw new IllegalStateException("You can't reset a dummy future.");
        }

        @Override
        public WriteFuture addListener(IoFutureListener<?> listener) {
            throw new IllegalStateException("You can't add a listener to a dummy future.");
        }

        @Override
        public WriteFuture removeListener(IoFutureListener<?> listener) {
            throw new IllegalStateException("You can't add a listener to a dummy future.");
        }

        @Override
        public WriteFuture await() throws InterruptedException {
            return this;
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public boolean await(long timeoutMillis) throws InterruptedException {
            return true;
        }

        @Override
        public WriteFuture awaitUninterruptibly() {
            return this;
        }

        @Override
        public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
            return true;
        }

        @Override
        public boolean awaitUninterruptibly(long timeoutMillis) {
            return true;
        }

        @Override
        public Throwable getException() {
            return null;
        }

        @Override
        public void setException(Throwable cause) {
        }
    };
    private Object message;
    private SocketAddress destination;
    private final WriteFutureEx future;

    public DefaultWriteRequestEx(Object message) {
        this(message, null, null);
    }

    public DefaultWriteRequestEx(Object message, WriteFutureEx future) {
        this(message, future, null);
    }

    public DefaultWriteRequestEx(Object message, WriteFutureEx future, SocketAddress destination) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (future == null) {
            future = UNUSED_FUTURE;
        }
        this.message = message;
        this.future = future;
        this.destination = destination;
    }

    private DefaultWriteRequestEx(WriteFutureEx future) {
        this.future = future;
    }

    @Override
    public boolean isResetable() {
        return this.future.isResetable();
    }

    @Override
    public void reset(IoSession session, Object message) {
        this.reset(session, message, null);
    }

    @Override
    public void reset(IoSession session, Object message, SocketAddress destination) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.future.reset(session);
        this.message = message;
        this.destination = destination;
    }

    @Override
    public WriteFutureEx getFuture() {
        return this.future;
    }

    @Override
    public Object getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(Object message) {
        this.message = message;
    }

    @Override
    public WriteRequest getOriginalRequest() {
        return this;
    }

    @Override
    public SocketAddress getDestination() {
        return this.destination;
    }

    public String toString() {
        if (this.getDestination() == null) {
            return this.message.toString();
        }
        return this.message.toString() + " => " + this.getDestination();
    }

    public static final class ShareableWriteRequest
    extends VicariousThreadLocal<WriteRequestEx> {
        @Override
        public WriteRequestEx get() {
            WriteRequestEx writeRequest = (WriteRequestEx)super.get();
            if (!writeRequest.isResetable()) {
                WriteRequestEx newValue = this.initialValue();
                this.set(newValue);
                writeRequest = newValue;
            }
            assert (writeRequest.isResetable());
            return writeRequest;
        }

        @Override
        protected WriteRequestEx initialValue() {
            DefaultWriteRequestEx writeRequest = new DefaultWriteRequestEx(new DefaultWriteFutureEx(){});
            return writeRequest;
        }

        public static List<ThreadLocal<WriteRequestEx>> initWithLayers(int ioLayers) {
            ArrayList<ShareableWriteRequest> threadLocals = new ArrayList<ShareableWriteRequest>(ioLayers);
            while (threadLocals.size() < ioLayers) {
                threadLocals.add(new ShareableWriteRequest());
            }
            return Collections.unmodifiableList(threadLocals);
        }
    }
}

