/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.core.session;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.service.DefaultTransportMetadata;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.DefaultIoSessionDataStructureFactory;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.SimpleBufferAllocator;
import org.kaazing.mina.core.future.BindFuture;
import org.kaazing.mina.core.future.UnbindFuture;
import org.kaazing.mina.core.service.AbstractIoAcceptorEx;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.service.IoServiceEx;
import org.kaazing.mina.core.session.AbstractIoSessionConfigEx;
import org.kaazing.mina.core.session.AbstractIoSessionEx;
import org.kaazing.mina.core.session.IoSessionConfigEx;
import org.kaazing.mina.core.write.DefaultWriteRequestEx;

public class DummySessionEx
extends AbstractIoSessionEx {
    private static final TransportMetadata TRANSPORT_METADATA = new DefaultTransportMetadata("mina", "dummy", false, true, SocketAddress.class, IoSessionConfig.class, Object.class);
    private static final SocketAddress ANONYMOUS_ADDRESS = new SocketAddress(){
        private static final long serialVersionUID = -496112902353454179L;

        public String toString() {
            return "?";
        }
    };
    private volatile IoServiceEx service;
    private volatile IoSessionConfigEx config = new AbstractIoSessionConfigEx(){

        @Override
        protected void doSetAll(IoSessionConfigEx config) {
        }
    };
    private final IoProcessorEx<AbstractIoSessionEx> processor;
    private volatile IoHandler handler = new IoHandlerAdapter();
    private volatile SocketAddress localAddress = ANONYMOUS_ADDRESS;
    private volatile SocketAddress remoteAddress = ANONYMOUS_ADDRESS;
    private volatile TransportMetadata transportMetadata = TRANSPORT_METADATA;

    public DummySessionEx() {
        this(CURRENT_THREAD, IMMEDIATE_EXECUTOR);
    }

    public DummySessionEx(Thread thread, Executor executor) {
        super(0, thread, executor, new DefaultWriteRequestEx.ShareableWriteRequest());
        AbstractIoAcceptorEx acceptor = new AbstractIoAcceptorEx(new AbstractIoSessionConfigEx(){

            @Override
            protected void doSetAll(IoSessionConfigEx config) {
            }
        }, new Executor(){

            @Override
            public void execute(Runnable command) {
            }
        }){

            @Override
            protected Set<SocketAddress> bindInternal(List<? extends SocketAddress> localAddresses) throws Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void unbind0(List<? extends SocketAddress> localAddresses) throws Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public IoSession newSession(SocketAddress remoteAddress, SocketAddress localAddress) {
                throw new UnsupportedOperationException();
            }

            @Override
            public TransportMetadata getTransportMetadata() {
                return TRANSPORT_METADATA;
            }

            @Override
            protected IoFuture dispose0() throws Exception {
                return null;
            }

            @Override
            protected BindFuture bindAsyncInternal(SocketAddress localAddress) {
                return null;
            }

            @Override
            public UnbindFuture unbindAsyncInternal(SocketAddress localAddress) {
                return null;
            }
        };
        acceptor.setHandler(new IoHandlerAdapter());
        this.service = acceptor;
        this.processor = new IoProcessorEx<AbstractIoSessionEx>(){

            @Override
            public void add(AbstractIoSessionEx session) {
            }

            @Override
            public void flush(AbstractIoSessionEx session) {
                DummySessionEx s = (DummySessionEx)session;
                WriteRequest req = s.getWriteRequestQueue().poll(session);
                if (req != null) {
                    Object m = req.getMessage();
                    if (m instanceof FileRegion) {
                        FileRegion file = (FileRegion)m;
                        try {
                            file.getFileChannel().position(file.getPosition() + file.getRemainingBytes());
                            file.update(file.getRemainingBytes());
                        }
                        catch (IOException e) {
                            s.getFilterChain().fireExceptionCaught(e);
                        }
                    }
                    DummySessionEx.this.getFilterChain().fireMessageSent(req);
                }
            }

            @Override
            public void remove(AbstractIoSessionEx session) {
                if (!session.getCloseFuture().isClosed()) {
                    session.getFilterChain().fireSessionClosed();
                }
            }

            @Override
            public void updateTrafficControl(AbstractIoSessionEx session) {
            }

            @Override
            public void dispose() {
            }

            @Override
            public boolean isDisposed() {
                return false;
            }

            @Override
            public boolean isDisposing() {
                return false;
            }
        };
        try {
            DefaultIoSessionDataStructureFactory factory = new DefaultIoSessionDataStructureFactory();
            this.setAttributeMap(factory.getAttributeMap(this));
            this.setWriteRequestQueue(factory.getWriteRequestQueue(this));
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }

    @Override
    public IoBufferAllocatorEx<?> getBufferAllocator() {
        return SimpleBufferAllocator.BUFFER_ALLOCATOR;
    }

    @Override
    public IoSessionConfigEx getConfig() {
        return this.config;
    }

    public void setConfig(IoSessionConfigEx config) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        this.config = config;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    public void setHandler(IoHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.handler = handler;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setLocalAddress(SocketAddress localAddress) {
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        this.localAddress = localAddress;
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        this.remoteAddress = remoteAddress;
    }

    @Override
    public IoServiceEx getService() {
        return this.service;
    }

    public void setService(IoServiceEx service) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        this.service = service;
    }

    @Override
    public final IoProcessorEx<AbstractIoSessionEx> getProcessor() {
        return this.processor;
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return this.transportMetadata;
    }

    public void setTransportMetadata(TransportMetadata transportMetadata) {
        if (transportMetadata == null) {
            throw new NullPointerException("transportMetadata");
        }
        this.transportMetadata = transportMetadata;
    }

    @Override
    public void setScheduledWriteBytes(int byteCount) {
        super.setScheduledWriteBytes(byteCount);
    }

    public void updateThroughput(boolean force) {
        super.updateThroughput(System.currentTimeMillis(), force);
    }
}

