/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.core.filterchain;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.mina.core.session.AbstractIoSessionEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.kaazing.mina.core.util.Util;

class AssertAlignedFilter
extends IoFilterAdapter {
    private static final boolean assertEnabled;
    private final IoSessionEx sessionEx;

    static final boolean isAssertEnabled() {
        return assertEnabled;
    }

    public AssertAlignedFilter(AbstractIoSessionEx session) {
        this.sessionEx = session;
    }

    @Override
    public void onPostAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (!assertEnabled) {
            parent.remove(this);
        } else {
            Util.verifyInIoThread(parent.getSession(), this.sessionEx.getIoThread());
        }
    }

    @Override
    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
    }

    @Override
    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
    }

    @Override
    public void onPreRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
    }

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        Util.verifyInIoThread(session, this.sessionEx.getIoThread());
        super.filterWrite(nextFilter, session, writeRequest);
    }

    @Override
    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        super.exceptionCaught(nextFilter, session, cause);
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        Util.verifyInIoThread(session, this.sessionEx.getIoThread());
        super.messageReceived(nextFilter, session, message);
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        Util.verifyInIoThread(session, this.sessionEx.getIoThread());
        super.messageSent(nextFilter, session, writeRequest);
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        Util.verifyInIoThread(session, this.sessionEx.getIoThread());
        super.sessionClosed(nextFilter, session);
    }

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        Util.verifyInIoThread(session, this.sessionEx.getIoThread());
        super.sessionCreated(nextFilter, session);
    }

    @Override
    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        Util.verifyInIoThread(session, this.sessionEx.getIoThread());
        super.sessionIdle(nextFilter, session, status);
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        Util.verifyInIoThread(session, this.sessionEx.getIoThread());
        super.sessionOpened(nextFilter, session);
    }

    static {
        boolean enabled;
        try {
            assert (false);
            enabled = false;
        }
        catch (AssertionError e) {
            enabled = true;
        }
        assertEnabled = enabled;
    }
}

