/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty.channel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelFutureProgressListener;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.internal.DeadLockProofWorker;

public class DefaultChannelFutureEx
implements ChannelFuture {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelFuture.class);
    private static final Throwable CANCELLED = new Throwable();
    private Channel channel;
    private boolean cancellable;
    private ChannelFutureListener firstListener;
    private List<ChannelFutureListener> otherListeners;
    private List<ChannelFutureProgressListener> progressListeners;
    private boolean done;
    private Throwable cause;
    private int waiters;

    public synchronized boolean isResetable() {
        return this.done && this.waiters == 0 || this.channel == null;
    }

    public synchronized void reset(Channel channel, boolean cancellable) {
        this.channel = channel;
        this.cancellable = cancellable;
        assert (this.firstListener == null);
        assert (this.otherListeners == null || this.otherListeners.isEmpty());
        assert (this.progressListeners == null || this.progressListeners.isEmpty());
        this.done = false;
        this.cause = null;
        assert (this.waiters == 0);
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public synchronized boolean isDone() {
        return this.done;
    }

    @Override
    public synchronized boolean isSuccess() {
        return this.done && this.cause == null;
    }

    @Override
    public synchronized Throwable getCause() {
        if (this.cause != CANCELLED) {
            return this.cause;
        }
        return null;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cause == CANCELLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ChannelFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        boolean notifyNow = false;
        DefaultChannelFutureEx defaultChannelFutureEx = this;
        synchronized (defaultChannelFutureEx) {
            if (this.done) {
                notifyNow = true;
            } else {
                if (this.firstListener == null) {
                    this.firstListener = listener;
                } else {
                    if (this.otherListeners == null) {
                        this.otherListeners = new ArrayList<ChannelFutureListener>(1);
                    }
                    this.otherListeners.add(listener);
                }
                if (listener instanceof ChannelFutureProgressListener) {
                    if (this.progressListeners == null) {
                        this.progressListeners = new ArrayList<ChannelFutureProgressListener>(1);
                    }
                    this.progressListeners.add((ChannelFutureProgressListener)listener);
                }
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ChannelFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        DefaultChannelFutureEx defaultChannelFutureEx = this;
        synchronized (defaultChannelFutureEx) {
            if (!this.done) {
                if (listener == this.firstListener) {
                    this.firstListener = this.otherListeners != null && !this.otherListeners.isEmpty() ? this.otherListeners.remove(0) : null;
                } else if (this.otherListeners != null) {
                    this.otherListeners.remove(listener);
                }
                if (listener instanceof ChannelFutureProgressListener) {
                    this.progressListeners.remove(listener);
                }
            }
        }
    }

    @Override
    @Deprecated
    public ChannelFuture rethrowIfFailed() throws Exception {
        if (!this.isDone()) {
            return this;
        }
        Throwable cause = this.getCause();
        if (cause == null) {
            return this;
        }
        if (cause instanceof Exception) {
            throw (Exception)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new RuntimeException(cause);
    }

    @Override
    public ChannelFuture sync() throws InterruptedException {
        this.await();
        this.rethrowIfFailed0();
        return this;
    }

    @Override
    public ChannelFuture syncUninterruptibly() {
        this.awaitUninterruptibly();
        this.rethrowIfFailed0();
        return this;
    }

    private void rethrowIfFailed0() {
        Throwable cause = this.getCause();
        if (cause == null) {
            return;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new ChannelException(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DefaultChannelFutureEx defaultChannelFutureEx = this;
        synchronized (defaultChannelFutureEx) {
            while (!this.done) {
                DefaultChannelFutureEx.checkDeadLock();
                ++this.waiters;
                try {
                    this.wait();
                }
                finally {
                    --this.waiters;
                }
            }
        }
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await0(unit.toNanos(timeout), true);
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture awaitUninterruptibly() {
        boolean interrupted = false;
        DefaultChannelFutureEx defaultChannelFutureEx = this;
        synchronized (defaultChannelFutureEx) {
            while (!this.done) {
                DefaultChannelFutureEx.checkDeadLock();
                ++this.waiters;
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                finally {
                    --this.waiters;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            return this.await0(unit.toNanos(timeout), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkDeadLock() {
        if (DefaultChannelFuture.isUseDeadLockChecker() && DeadLockProofWorker.PARENT.get() != null) {
            throw new IllegalStateException("await*() in I/O thread causes a dead lock or sudden performance drop. Use addListener() instead or call await*() from a different thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSuccess() {
        DefaultChannelFutureEx defaultChannelFutureEx = this;
        synchronized (defaultChannelFutureEx) {
            if (this.done) {
                return false;
            }
            this.done = true;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.notifyListeners();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFailure(Throwable cause) {
        DefaultChannelFutureEx defaultChannelFutureEx = this;
        synchronized (defaultChannelFutureEx) {
            if (this.done) {
                return false;
            }
            this.cause = cause;
            this.done = true;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.notifyListeners();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        if (!this.cancellable) {
            return false;
        }
        DefaultChannelFutureEx defaultChannelFutureEx = this;
        synchronized (defaultChannelFutureEx) {
            if (this.done) {
                return false;
            }
            this.cause = CANCELLED;
            this.done = true;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.notifyListeners();
        return true;
    }

    private void notifyListeners() {
        ChannelFutureListener firstListener = this.firstListener;
        if (firstListener != null) {
            List<ChannelFutureListener> otherListeners = this.otherListeners;
            List<ChannelFutureProgressListener> progressListeners = this.progressListeners;
            this.firstListener = null;
            this.otherListeners = null;
            if (progressListeners != null) {
                progressListeners.clear();
            }
            this.notifyListener(firstListener);
            if (otherListeners != null) {
                for (ChannelFutureListener l : otherListeners) {
                    this.notifyListener(l);
                }
            }
        }
    }

    private void notifyListener(ChannelFutureListener l) {
        block2: {
            try {
                l.operationComplete(this);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + ChannelFutureListener.class.getSimpleName() + '.', t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setProgress(long amount, long current, long total) {
        ChannelFutureProgressListener[] plisteners;
        DefaultChannelFutureEx defaultChannelFutureEx = this;
        synchronized (defaultChannelFutureEx) {
            if (this.done) {
                return false;
            }
            List<ChannelFutureProgressListener> progressListeners = this.progressListeners;
            if (progressListeners == null || progressListeners.isEmpty()) {
                return true;
            }
            plisteners = progressListeners.toArray(new ChannelFutureProgressListener[progressListeners.size()]);
        }
        for (ChannelFutureProgressListener pl : plisteners) {
            this.notifyProgressListener(pl, amount, current, total);
        }
        return true;
    }

    private void notifyProgressListener(ChannelFutureProgressListener l, long amount, long current, long total) {
        block2: {
            try {
                l.operationProgressed(this, amount, current, total);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + ChannelFutureProgressListener.class.getSimpleName() + '.', t);
            }
        }
    }
}

