/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty.bootstrap;

import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ServerChannelFactory;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.kaazing.mina.netty.bootstrap.ConnectionlessBootstrap;
import org.kaazing.mina.netty.bootstrap.ServerBootstrap;

class ConnectionlessServerBootstrap
extends ConnectionlessBootstrap
implements ServerBootstrap {
    private ChannelHandler parentHandler;

    ConnectionlessServerBootstrap() {
    }

    @Override
    public void setFactory(ChannelFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (!(factory instanceof ServerChannelFactory)) {
            final ChannelFactory factory0 = factory;
            factory = new ChannelFactory(){

                @Override
                public Channel newChannel(ChannelPipeline pipeline) {
                    return factory0.newChannel(Channels.pipeline(new ConnectionlessParentChannelHandler()));
                }

                @Override
                public void shutdown() {
                    factory0.shutdown();
                }

                @Override
                public void releaseExternalResources() {
                    factory0.releaseExternalResources();
                }
            };
        }
        super.setFactory(factory);
    }

    @Override
    public void setParentHandler(ChannelHandler parentHandler) {
        this.parentHandler = parentHandler;
    }

    @Override
    public ChannelHandler getParentHandler() {
        return this.parentHandler;
    }

    private final class ConnectionlessParentChannelHandler
    extends SimpleChannelUpstreamHandler {
        private final Map<SocketAddress, Map<SocketAddress, Channel>> childChannelsByLocalAddress = new ConcurrentHashMap<SocketAddress, Map<SocketAddress, Channel>>();

        @Override
        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            super.channelConnected(ctx, e);
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            ctx.sendUpstream(e);
        }

        private Channel getChildChannel(Channel channel, SocketAddress remoteAddress, boolean createIfNull) throws Exception {
            ConcurrentHashMap<SocketAddress, Channel> newChildChannels;
            SocketAddress localAddress = channel.getLocalAddress();
            ConcurrentHashMap<SocketAddress, Channel> childChannelsByRemoteAddress = this.childChannelsByLocalAddress.get(localAddress);
            if (childChannelsByRemoteAddress == null && createIfNull && (childChannelsByRemoteAddress = (ConcurrentHashMap<SocketAddress, Channel>)this.childChannelsByLocalAddress.put(localAddress, newChildChannels = new ConcurrentHashMap<SocketAddress, Channel>())) == null) {
                childChannelsByRemoteAddress = newChildChannels;
            }
            if (childChannelsByRemoteAddress != null) {
                Channel childChannel = childChannelsByRemoteAddress.get(remoteAddress);
                if (childChannel == null && createIfNull) {
                    ChannelPipelineFactory childPipelineFactory = ConnectionlessServerBootstrap.this.getPipelineFactory();
                    ChannelPipeline newChildPipeline = childPipelineFactory.getPipeline();
                    ChannelFactory channelFactory = channel.getFactory();
                    Channel newChildChannel = channelFactory.newChannel(newChildPipeline);
                    childChannel = childChannelsByRemoteAddress.put(remoteAddress, newChildChannel);
                    if (childChannel == null) {
                        newChildChannel.connect(remoteAddress);
                        childChannel = newChildChannel;
                    }
                }
                if (childChannel != null) {
                    final ConcurrentHashMap<SocketAddress, Channel> childChannelsByRemoteAddress0 = childChannelsByRemoteAddress;
                    final SocketAddress remoteAddress0 = remoteAddress;
                    ChannelFuture closeFuture = childChannel.getCloseFuture();
                    closeFuture.addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future) throws Exception {
                            childChannelsByRemoteAddress0.remove(remoteAddress0);
                        }
                    });
                }
                return childChannel;
            }
            return null;
        }
    }
}

