/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.kaazing.mina.core.buffer.AbstractIoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.AbstractIoBufferEx;
import org.kaazing.mina.netty.util.threadlocal.VicariousThreadLocal;

public final class ChannelIoBufferAllocator
extends AbstractIoBufferAllocatorEx<ChannelIoBuffer> {
    @Override
    public ByteBuffer allocate(int capacity, int flags) {
        return this.allocateNioBuffer0(capacity, flags);
    }

    @Override
    public ChannelIoBuffer wrap(ByteBuffer nioBuffer, int flags) {
        boolean shared = (flags & 2) != 0;
        return shared ? new ChannelIoSharedBuffer(nioBuffer) : new ChannelIoUnsharedBuffer(nioBuffer);
    }

    static final class ChannelIoUnsharedBuffer
    extends ChannelIoBuffer {
        private ByteBuffer buf;

        private ChannelIoUnsharedBuffer(ByteBuffer buf) {
            super(buf.capacity());
            this.buf = buf;
            buf.order(ByteOrder.BIG_ENDIAN);
        }

        private ChannelIoUnsharedBuffer(ChannelIoBuffer parent, ByteBuffer buf) {
            super(parent);
            this.buf = buf;
            buf.order(ByteOrder.BIG_ENDIAN);
        }

        @Override
        public int flags() {
            return 0;
        }

        @Override
        public ByteBuffer buf() {
            return this.buf;
        }

        @Override
        public void buf(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public byte[] array() {
            return this.buf.array();
        }

        @Override
        public int arrayOffset() {
            return this.buf.arrayOffset();
        }

        @Override
        public boolean hasArray() {
            return this.buf.hasArray();
        }

        @Override
        protected ChannelIoSharedBuffer asSharedBuffer0() {
            return new ChannelIoSharedBuffer(this.buf());
        }

        @Override
        protected ChannelIoBuffer asUnsharedBuffer0() {
            return this;
        }

        @Override
        protected ChannelIoUnsharedBuffer duplicate0() {
            return new ChannelIoUnsharedBuffer(this, this.buf.duplicate());
        }

        @Override
        protected ChannelIoUnsharedBuffer slice0() {
            return new ChannelIoUnsharedBuffer(this, this.buf.slice());
        }

        @Override
        protected ChannelIoUnsharedBuffer asReadOnlyBuffer0() {
            return new ChannelIoUnsharedBuffer(this, this.buf.asReadOnlyBuffer());
        }
    }

    static final class ChannelIoSharedBuffer
    extends ChannelIoBuffer {
        private final ThreadLocal<ByteBuffer> bufRef;

        private ChannelIoSharedBuffer(final ByteBuffer buf) {
            super(buf.capacity());
            this.bufRef = new VicariousThreadLocal<ByteBuffer>(){

                @Override
                protected ByteBuffer initialValue() {
                    return buf.duplicate();
                }
            };
        }

        private ChannelIoSharedBuffer(ChannelIoBuffer parent, final ByteBuffer buf) {
            super(parent);
            this.bufRef = new VicariousThreadLocal<ByteBuffer>(){

                @Override
                protected ByteBuffer initialValue() {
                    return buf.duplicate();
                }
            };
        }

        @Override
        public ByteBuffer buf() {
            return this.bufRef.get();
        }

        @Override
        public void buf(ByteBuffer buf) {
            this.bufRef.set(buf);
        }

        @Override
        public int flags() {
            return 2;
        }

        @Override
        public byte[] array() {
            return this.buf().array();
        }

        @Override
        public int arrayOffset() {
            return this.buf().arrayOffset();
        }

        @Override
        public boolean hasArray() {
            return this.buf().hasArray();
        }

        @Override
        protected ChannelIoSharedBuffer asSharedBuffer0() {
            return this;
        }

        @Override
        protected ChannelIoBuffer asUnsharedBuffer0() {
            return new ChannelIoUnsharedBuffer(this.buf());
        }

        @Override
        protected ChannelIoUnsharedBuffer duplicate0() {
            return new ChannelIoUnsharedBuffer(this, this.buf().duplicate());
        }

        @Override
        protected ChannelIoUnsharedBuffer slice0() {
            return new ChannelIoUnsharedBuffer(this, this.buf().slice());
        }

        @Override
        protected ChannelIoUnsharedBuffer asReadOnlyBuffer0() {
            return new ChannelIoUnsharedBuffer(this, this.buf().asReadOnlyBuffer());
        }
    }

    static abstract class ChannelIoBuffer
    extends AbstractIoBufferEx {
        protected ChannelIoBuffer(int capacity) {
            super(capacity);
        }

        protected ChannelIoBuffer(ChannelIoBuffer parent) {
            super(parent);
        }

        @Override
        public abstract void buf(ByteBuffer var1);

        @Override
        public void free() {
        }
    }
}

