/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.filter.codec;

import java.nio.ByteBuffer;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;

public abstract class CumulativeProtocolDecoderEx
extends ProtocolDecoderAdapter {
    private final AttributeKey BUFFER = new AttributeKey(this.getClass(), "buffer");
    private final IoBufferAllocatorEx<?> allocator;

    protected CumulativeProtocolDecoderEx(IoBufferAllocatorEx<?> allocator) {
        this.allocator = allocator;
    }

    @Override
    public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        IoBufferEx inEx = (IoBufferEx)((Object)in);
        if (!session.getTransportMetadata().hasFragmentation()) {
            while (in.hasRemaining() && this.doDecode(session, inEx, out)) {
            }
            return;
        }
        boolean usingSessionBuffer = true;
        IoBufferEx buf = (IoBufferEx)session.getAttribute(this.BUFFER);
        if (buf != null) {
            boolean appended = false;
            if (buf.isAutoExpand()) {
                try {
                    buf.put(inEx);
                    appended = true;
                }
                catch (IllegalStateException e) {
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
            if (appended) {
                buf.flip();
            } else {
                buf.flip();
                ByteBuffer newNioBuf = this.allocator.allocate(buf.remaining() + in.remaining());
                IoBufferEx newBuf = this.allocator.wrap(newNioBuf).setAutoExpander(this.allocator);
                newBuf.order(buf.order());
                newBuf.put(buf);
                newBuf.put(inEx);
                newBuf.flip();
                buf = newBuf;
                session.setAttribute(this.BUFFER, buf);
            }
        } else {
            buf = inEx;
            usingSessionBuffer = false;
        }
        do {
            int oldPos = buf.position();
            boolean decoded = this.doDecode(session, buf, out);
            if (!decoded) break;
            if (buf.position() != oldPos) continue;
            throw new IllegalStateException("doDecode() can't return true when buffer is not consumed.");
        } while (buf.hasRemaining());
        if (buf.hasRemaining()) {
            this.storeRemainingInSession(buf, session);
        } else if (usingSessionBuffer) {
            this.removeSessionBuffer(session);
        }
    }

    protected abstract boolean doDecode(IoSession var1, IoBufferEx var2, ProtocolDecoderOutput var3) throws Exception;

    @Override
    public void dispose(IoSession session) throws Exception {
        this.removeSessionBuffer(session);
    }

    private void removeSessionBuffer(IoSession session) {
        session.removeAttribute(this.BUFFER);
    }

    private void storeRemainingInSession(IoBufferEx buf, IoSession session) {
        ByteBuffer remainingNioBuf = this.allocator.allocate(buf.capacity(), buf.flags());
        IoBufferEx remainingBuf = this.allocator.wrap(remainingNioBuf).setAutoExpander(this.allocator);
        remainingBuf.mark();
        remainingBuf.order(buf.order());
        remainingBuf.put(buf);
        session.setAttribute(this.BUFFER, remainingBuf);
    }
}

