/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.core.session;

import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.kaazing.mina.core.filterchain.DefaultIoFilterChain;
import org.kaazing.mina.core.filterchain.DefaultIoFilterChainEx;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.session.AbstractIoSession;
import org.kaazing.mina.core.session.IoSessionEx;
import org.kaazing.mina.core.write.WriteRequestEx;

public abstract class AbstractIoSessionEx
extends AbstractIoSession
implements IoSessionEx {
    private final boolean ioAligned;
    private final int ioLayer;
    private final ThreadLocal<WriteRequestEx> ioWriteRequest;
    private final Runnable readSuspender;
    private final Runnable readResumer;
    private volatile IoFilterChain filterChain;
    private volatile Thread ioThread;
    private volatile Executor ioExecutor;
    private volatile boolean ioRegistered;
    private Runnable closeOnFlushTask = new Runnable(){

        @Override
        public void run() {
            AbstractIoSessionEx.this.getWriteRequestQueue().offer(AbstractIoSessionEx.this, AbstractIoSession.CLOSE_REQUEST);
            AbstractIoSessionEx.this.getProcessor().flush(AbstractIoSessionEx.this);
        }
    };

    protected AbstractIoSessionEx(int ioLayer, Thread ioThread, Executor ioExecutor, ThreadLocal<WriteRequestEx> ioWriteRequest) {
        boolean ioRegistered;
        boolean ioAligned;
        if (ioThread == null) {
            throw new NullPointerException("ioThread");
        }
        if (ioExecutor == null) {
            throw new NullPointerException("ioExecutor");
        }
        this.ioLayer = ioLayer;
        this.ioWriteRequest = ioWriteRequest;
        this.ioAligned = ioAligned = ioExecutor != IMMEDIATE_EXECUTOR && ioThread != CURRENT_THREAD;
        this.ioThread = ioThread;
        this.ioExecutor = ioExecutor;
        this.ioRegistered = ioRegistered = ioExecutor != NO_EXECUTOR && ioThread != NO_THREAD;
        this.filterChain = ioAligned ? new DefaultIoFilterChainEx(this) : new DefaultIoFilterChain(this);
        this.readSuspender = new Runnable(){

            @Override
            public void run() {
                AbstractIoSessionEx.this.suspendRead1();
            }
        };
        this.readResumer = new Runnable(){

            @Override
            public void run() {
                AbstractIoSessionEx.this.resumeRead1();
            }
        };
    }

    @Override
    public final int getIoLayer() {
        return this.ioLayer;
    }

    @Override
    public final boolean isIoAligned() {
        return this.ioAligned;
    }

    @Override
    public final boolean isIoRegistered() {
        return this.ioRegistered;
    }

    @Override
    public final void setIoAlignment(Thread ioThread, Executor ioExecutor) {
        boolean ioRegistered;
        if (!this.ioAligned) {
            throw new IllegalStateException("ioAligned = false");
        }
        if (ioThread == null) {
            throw new NullPointerException("ioThread");
        }
        if (ioExecutor == null) {
            throw new NullPointerException("ioExecutor");
        }
        boolean bl = ioRegistered = ioExecutor != NO_EXECUTOR && ioThread != NO_THREAD;
        if (ioRegistered && Thread.currentThread() != ioThread) {
            throw new RuntimeException("Not called from I/O thread");
        }
        DefaultIoFilterChainEx filterChain = (DefaultIoFilterChainEx)this.filterChain;
        DefaultIoFilterChainEx newFilterChain = new DefaultIoFilterChainEx(filterChain, ioThread, ioExecutor);
        this.filterChain = newFilterChain;
        this.ioThread = ioThread;
        this.ioExecutor = ioExecutor;
        this.ioRegistered = ioRegistered;
        this.setIoAlignment0(ioThread, ioExecutor);
        if (ioRegistered) {
            newFilterChain.fireMessageSent(REGISTERED_EVENT);
        }
    }

    @Override
    public final IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    @Override
    public final Thread getIoThread() {
        return this.ioThread;
    }

    @Override
    public final Executor getIoExecutor() {
        return this.ioExecutor;
    }

    protected void setIoAlignment0(Thread ioThread, Executor ioExecutor) {
    }

    @Override
    protected WriteRequestEx nextWriteRequest(Object message, SocketAddress remoteAddress) {
        if (this.ioAligned) {
            WriteRequestEx writeRequest = this.ioWriteRequest.get();
            writeRequest.reset(this, message, remoteAddress);
            return writeRequest;
        }
        return super.nextWriteRequest(message, remoteAddress);
    }

    @Override
    public abstract IoProcessorEx getProcessor();

    @Override
    protected final void suspendRead0() {
        if (Thread.currentThread() == this.ioThread) {
            this.readSuspender.run();
        } else {
            this.ioExecutor.execute(this.readSuspender);
        }
    }

    protected void suspendRead1() {
        super.suspendRead0();
    }

    @Override
    protected final void resumeRead0() {
        if (Thread.currentThread() == this.ioThread) {
            this.readResumer.run();
        } else {
            this.ioExecutor.execute(this.readResumer);
        }
    }

    protected void resumeRead1() {
        super.resumeRead0();
    }

    @Override
    protected void doCloseOnFlush() {
        if (Thread.currentThread() == this.ioThread) {
            this.closeOnFlushTask.run();
        } else {
            this.getIoExecutor().execute(this.closeOnFlushTask);
        }
    }
}

