/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.core.session;

import org.apache.mina.core.session.AbstractIoSessionConfig;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSessionConfig;
import org.kaazing.mina.core.session.IoSessionConfigEx;

public abstract class AbstractIoSessionConfigEx
extends AbstractIoSessionConfig
implements IoSessionConfigEx {
    private static final IoSessionConfigEx.ChangeListener DEFAULT_CHANGE_LISTENER = new IoSessionConfigEx.ChangeListener(){

        @Override
        public void idleTimeInMillisChanged(IdleStatus status, long idleTimeMillis) {
        }
    };
    private volatile long idleTimeMillisForRead;
    private volatile long idleTimeMillisForWrite;
    private volatile long idleTimeMillisForBoth;
    private volatile IoSessionConfigEx.ChangeListener listener = DEFAULT_CHANGE_LISTENER;

    @Override
    protected final void doSetAll(IoSessionConfig config) {
        this.setIdleTimeInMillis(IdleStatus.BOTH_IDLE, config.getBothIdleTimeInMillis());
        this.setIdleTimeInMillis(IdleStatus.READER_IDLE, config.getReaderIdleTimeInMillis());
        this.setIdleTimeInMillis(IdleStatus.WRITER_IDLE, config.getWriterIdleTimeInMillis());
        this.doSetAll((IoSessionConfigEx)config);
    }

    protected abstract void doSetAll(IoSessionConfigEx var1);

    @Override
    public void setChangeListener(IoSessionConfigEx.ChangeListener listener) {
        IoSessionConfigEx.ChangeListener oldListener = this.listener;
        IoSessionConfigEx.ChangeListener newListener = listener != null ? listener : DEFAULT_CHANGE_LISTENER;
        oldListener.idleTimeInMillisChanged(IdleStatus.BOTH_IDLE, 0L);
        oldListener.idleTimeInMillisChanged(IdleStatus.READER_IDLE, 0L);
        oldListener.idleTimeInMillisChanged(IdleStatus.WRITER_IDLE, 0L);
        this.listener = newListener;
        newListener.idleTimeInMillisChanged(IdleStatus.BOTH_IDLE, this.idleTimeMillisForBoth);
        newListener.idleTimeInMillisChanged(IdleStatus.READER_IDLE, this.idleTimeMillisForRead);
        newListener.idleTimeInMillisChanged(IdleStatus.WRITER_IDLE, this.idleTimeMillisForWrite);
    }

    @Override
    public int getIdleTime(IdleStatus status) {
        return (int)this.getIdleTimeInMillis(status) / 1000;
    }

    @Override
    public long getIdleTimeInMillis(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.idleTimeMillisForBoth;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.idleTimeMillisForRead;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.idleTimeMillisForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    @Override
    public void setIdleTime(IdleStatus status, int idleTime) {
        if (idleTime < 0) {
            throw new IllegalArgumentException("Illegal idle time: " + idleTime);
        }
        long idleTimeMillis = (long)idleTime * 1000L;
        this.setIdleTimeInMillis(status, idleTimeMillis);
    }

    @Override
    public void setIdleTimeInMillis(IdleStatus status, long idleTimeMillis) {
        if (idleTimeMillis < 0L) {
            throw new IllegalArgumentException("Illegal idle time: " + idleTimeMillis);
        }
        if (status == IdleStatus.BOTH_IDLE) {
            long idleTimeMillisForBoth = this.idleTimeMillisForBoth;
            if (idleTimeMillis != idleTimeMillisForBoth) {
                this.idleTimeMillisForBoth = idleTimeMillis;
                this.listener.idleTimeInMillisChanged(status, idleTimeMillis);
            }
        } else if (status == IdleStatus.READER_IDLE) {
            long idleTimeMillisForRead = this.idleTimeMillisForRead;
            if (idleTimeMillis != idleTimeMillisForRead) {
                this.idleTimeMillisForRead = idleTimeMillis;
                this.listener.idleTimeInMillisChanged(status, idleTimeMillis);
            }
        } else if (status == IdleStatus.WRITER_IDLE) {
            long idleTimeMillisForWrite = this.idleTimeMillisForWrite;
            if (idleTimeMillis != idleTimeMillisForWrite) {
                this.idleTimeMillisForWrite = idleTimeMillis;
                this.listener.idleTimeInMillisChanged(status, idleTimeMillis);
            }
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + status);
        }
    }
}

