/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.beans;

import java.net.InetSocketAddress;
import org.apache.mina.integration.beans.AbstractPropertyEditor;

public class InetSocketAddressEditor
extends AbstractPropertyEditor {
    @Override
    protected String toText(Object value) {
        InetSocketAddress addr = (InetSocketAddress)value;
        String hostname = addr.getAddress() != null ? addr.getAddress().getHostAddress() : addr.getHostName();
        if (hostname.equals("0:0:0:0:0:0:0:0") || hostname.equals("0.0.0.0") || hostname.equals("00:00:00:00:00:00:00:00")) {
            hostname = "*";
        }
        return hostname + ':' + addr.getPort();
    }

    @Override
    protected Object toValue(String text) throws IllegalArgumentException {
        String host;
        if (text.length() == 0) {
            return this.defaultValue();
        }
        int colonIndex = text.lastIndexOf(":");
        if (colonIndex > 0 && !"*".equals(host = text.substring(0, colonIndex))) {
            int port = this.parsePort(text.substring(colonIndex + 1));
            return new InetSocketAddress(host, port);
        }
        int port = this.parsePort(text.substring(colonIndex + 1));
        return new InetSocketAddress(port);
    }

    @Override
    protected String defaultText() {
        return "*:0";
    }

    @Override
    protected Object defaultValue() {
        return new InetSocketAddress(0);
    }

    private int parsePort(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Illegal port number: " + s);
        }
    }
}

