/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.beans;

import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.mina.integration.beans.AbstractPropertyEditor;

public class EnumEditor
extends AbstractPropertyEditor {
    private static final Pattern ORDINAL = Pattern.compile("[0-9]+");
    private final Class enumType;
    private final Set<Enum> enums;

    public EnumEditor(Class enumType) {
        if (enumType == null) {
            throw new NullPointerException("enumType");
        }
        this.enumType = enumType;
        this.enums = EnumSet.allOf(enumType);
    }

    protected String toText(Object value) {
        return value.toString();
    }

    protected Object toValue(String text) throws IllegalArgumentException {
        if (ORDINAL.matcher(text).matches()) {
            int ordinal = Integer.parseInt(text);
            for (Enum e : this.enums) {
                if (e.ordinal() != ordinal) continue;
                return e;
            }
            throw new IllegalArgumentException("wrong ordinal: " + ordinal);
        }
        for (Enum e : this.enums) {
            if (!text.equalsIgnoreCase(e.toString())) continue;
            return e;
        }
        return Enum.valueOf(this.enumType, text);
    }
}

