/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import java.net.SocketAddress;
import java.util.Queue;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.DefaultWriteFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.NothingWrittenException;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestWrapper;
import org.apache.mina.filter.codec.AbstractProtocolDecoderOutput;
import org.apache.mina.filter.codec.AbstractProtocolEncoderOutput;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.RecoverableProtocolDecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolCodecFilter
extends IoFilterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolCodecFilter.class);
    private static final Class<?>[] EMPTY_PARAMS = new Class[0];
    private static final IoBuffer EMPTY_BUFFER = IoBuffer.wrap(new byte[0]);
    private static final AttributeKey ENCODER = new AttributeKey(ProtocolCodecFilter.class, "encoder");
    private static final AttributeKey DECODER = new AttributeKey(ProtocolCodecFilter.class, "decoder");
    private static final AttributeKey DECODER_OUT = new AttributeKey(ProtocolCodecFilter.class, "decoderOut");
    private static final AttributeKey ENCODER_OUT = new AttributeKey(ProtocolCodecFilter.class, "encoderOut");
    private final ProtocolCodecFactory factory;

    public ProtocolCodecFilter(ProtocolCodecFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
    }

    public ProtocolCodecFilter(final ProtocolEncoder encoder, final ProtocolDecoder decoder) {
        if (encoder == null) {
            throw new NullPointerException("encoder");
        }
        if (decoder == null) {
            throw new NullPointerException("decoder");
        }
        this.factory = new ProtocolCodecFactory(){

            @Override
            public ProtocolEncoder getEncoder(IoSession session) {
                return encoder;
            }

            @Override
            public ProtocolDecoder getDecoder(IoSession session) {
                return decoder;
            }
        };
    }

    public ProtocolCodecFilter(final Class<? extends ProtocolEncoder> encoderClass, final Class<? extends ProtocolDecoder> decoderClass) {
        if (encoderClass == null) {
            throw new NullPointerException("encoderClass");
        }
        if (decoderClass == null) {
            throw new NullPointerException("decoderClass");
        }
        if (!ProtocolEncoder.class.isAssignableFrom(encoderClass)) {
            throw new IllegalArgumentException("encoderClass: " + encoderClass.getName());
        }
        if (!ProtocolDecoder.class.isAssignableFrom(decoderClass)) {
            throw new IllegalArgumentException("decoderClass: " + decoderClass.getName());
        }
        try {
            encoderClass.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("encoderClass doesn't have a public default constructor.");
        }
        try {
            decoderClass.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("decoderClass doesn't have a public default constructor.");
        }
        this.factory = new ProtocolCodecFactory(){

            @Override
            public ProtocolEncoder getEncoder(IoSession session) throws Exception {
                return (ProtocolEncoder)encoderClass.newInstance();
            }

            @Override
            public ProtocolDecoder getDecoder(IoSession session) throws Exception {
                return (ProtocolDecoder)decoderClass.newInstance();
            }
        };
    }

    public ProtocolEncoder getEncoder(IoSession session) {
        return (ProtocolEncoder)session.getAttribute(ENCODER);
    }

    @Override
    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(this)) {
            throw new IllegalArgumentException("You can't add the same filter instance more than once.  Create another instance and add it.");
        }
        this.initCodec(parent.getSession());
    }

    @Override
    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        this.disposeCodec(parent.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        LOGGER.debug("Processing a MESSAGE_RECEIVED for session {}", (Object)session.getId());
        if (!(message instanceof IoBuffer)) {
            nextFilter.messageReceived(session, message);
            return;
        }
        IoBuffer in = (IoBuffer)message;
        ProtocolDecoder decoder = this.getDecoder(session);
        ProtocolDecoderOutput decoderOut = this.getDecoderOut(session, nextFilter);
        while (in.hasRemaining()) {
            int oldPos = in.position();
            try {
                ProtocolDecoderOutput protocolDecoderOutput = decoderOut;
                synchronized (protocolDecoderOutput) {
                    decoder.decode(session, in, decoderOut);
                }
                decoderOut.flush(nextFilter, session);
            }
            catch (Throwable t) {
                ProtocolDecoderException pde = t instanceof ProtocolDecoderException ? (ProtocolDecoderException)t : new ProtocolDecoderException(t);
                if (pde.getHexdump() == null) {
                    int curPos = in.position();
                    in.position(oldPos);
                    pde.setHexdump(in.getHexDump());
                    in.position(curPos);
                }
                decoderOut.flush(nextFilter, session);
                nextFilter.exceptionCaught(session, pde);
                if (t instanceof RecoverableProtocolDecoderException && in.position() != oldPos) continue;
                break;
            }
        }
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (writeRequest instanceof EncodedWriteRequest) {
            return;
        }
        if (writeRequest instanceof MessageWriteRequest) {
            MessageWriteRequest wrappedRequest = (MessageWriteRequest)writeRequest;
            nextFilter.messageSent(session, wrappedRequest.getParentRequest());
        } else {
            nextFilter.messageSent(session, writeRequest);
        }
    }

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        Object message = writeRequest.getMessage();
        if (message instanceof IoBuffer || message instanceof FileRegion) {
            nextFilter.filterWrite(session, writeRequest);
            return;
        }
        ProtocolEncoder encoder = this.getEncoder(session);
        ProtocolEncoderOutput encoderOut = this.getEncoderOut(session, nextFilter, writeRequest);
        try {
            encoder.encode(session, message, encoderOut);
            ((ProtocolEncoderOutputImpl)encoderOut).flushWithoutFuture();
            nextFilter.filterWrite(session, new MessageWriteRequest(writeRequest));
        }
        catch (Throwable t) {
            ProtocolEncoderException pee = t instanceof ProtocolEncoderException ? (ProtocolEncoderException)t : new ProtocolEncoderException(t);
            throw pee;
        }
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        ProtocolDecoder decoder = this.getDecoder(session);
        ProtocolDecoderOutput decoderOut = this.getDecoderOut(session, nextFilter);
        try {
            decoder.finishDecode(session, decoderOut);
        }
        catch (Throwable t) {
            ProtocolDecoderException pde = t instanceof ProtocolDecoderException ? (ProtocolDecoderException)t : new ProtocolDecoderException(t);
            throw pde;
        }
        finally {
            this.disposeCodec(session);
            decoderOut.flush(nextFilter, session);
        }
        nextFilter.sessionClosed(session);
    }

    private void initCodec(IoSession session) throws Exception {
        ProtocolDecoder decoder = this.factory.getDecoder(session);
        session.setAttribute(DECODER, decoder);
        ProtocolEncoder encoder = this.factory.getEncoder(session);
        session.setAttribute(ENCODER, encoder);
    }

    private void disposeCodec(IoSession session) {
        this.disposeEncoder(session);
        this.disposeDecoder(session);
        this.disposeDecoderOut(session);
    }

    private void disposeEncoder(IoSession session) {
        ProtocolEncoder encoder = (ProtocolEncoder)session.removeAttribute(ENCODER);
        if (encoder == null) {
            return;
        }
        try {
            encoder.dispose(session);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to dispose: " + encoder.getClass().getName() + " (" + encoder + ')');
        }
    }

    private ProtocolDecoder getDecoder(IoSession session) {
        return (ProtocolDecoder)session.getAttribute(DECODER);
    }

    private void disposeDecoder(IoSession session) {
        ProtocolDecoder decoder = (ProtocolDecoder)session.removeAttribute(DECODER);
        if (decoder == null) {
            return;
        }
        try {
            decoder.dispose(session);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to dispose: " + decoder.getClass().getName() + " (" + decoder + ')');
        }
    }

    private ProtocolDecoderOutput getDecoderOut(IoSession session, IoFilter.NextFilter nextFilter) {
        ProtocolDecoderOutput out = (ProtocolDecoderOutput)session.getAttribute(DECODER_OUT);
        if (out == null) {
            out = new ProtocolDecoderOutputImpl();
            session.setAttribute(DECODER_OUT, out);
        }
        return out;
    }

    private ProtocolEncoderOutput getEncoderOut(IoSession session, IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
        ProtocolEncoderOutput out = (ProtocolEncoderOutput)session.getAttribute(ENCODER_OUT);
        if (out == null) {
            out = new ProtocolEncoderOutputImpl(session, nextFilter, writeRequest);
            session.setAttribute(ENCODER_OUT, out);
        }
        return out;
    }

    private void disposeDecoderOut(IoSession session) {
        session.removeAttribute(DECODER_OUT);
    }

    private static class ProtocolEncoderOutputImpl
    extends AbstractProtocolEncoderOutput {
        private final IoSession session;
        private final IoFilter.NextFilter nextFilter;
        private final WriteRequest writeRequest;

        public ProtocolEncoderOutputImpl(IoSession session, IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
            this.session = session;
            this.nextFilter = nextFilter;
            this.writeRequest = writeRequest;
        }

        @Override
        public WriteFuture flush() {
            Object encodedMessage;
            Queue<Object> bufferQueue = this.getMessageQueue();
            WriteFuture future = null;
            while ((encodedMessage = bufferQueue.poll()) != null) {
                if (encodedMessage instanceof IoBuffer && !((IoBuffer)encodedMessage).hasRemaining()) continue;
                future = new DefaultWriteFuture(this.session);
                this.nextFilter.filterWrite(this.session, new EncodedWriteRequest(encodedMessage, future, this.writeRequest.getDestination()));
            }
            if (future == null) {
                future = DefaultWriteFuture.newNotWrittenFuture(this.session, new NothingWrittenException(this.writeRequest));
            }
            return future;
        }

        public void flushWithoutFuture() {
            Object encodedMessage;
            Queue<Object> bufferQueue = this.getMessageQueue();
            while ((encodedMessage = bufferQueue.poll()) != null) {
                if (encodedMessage instanceof IoBuffer && !((IoBuffer)encodedMessage).hasRemaining()) continue;
                SocketAddress destination = this.writeRequest.getDestination();
                EncodedWriteRequest writeRequest = new EncodedWriteRequest(encodedMessage, null, destination);
                this.nextFilter.filterWrite(this.session, writeRequest);
            }
        }
    }

    private static class ProtocolDecoderOutputImpl
    extends AbstractProtocolDecoderOutput {
        @Override
        public void flush(IoFilter.NextFilter nextFilter, IoSession session) {
            Queue<Object> messageQueue = this.getMessageQueue();
            while (!messageQueue.isEmpty()) {
                nextFilter.messageReceived(session, messageQueue.poll());
            }
        }
    }

    private static class MessageWriteRequest
    extends WriteRequestWrapper {
        public MessageWriteRequest(WriteRequest writeRequest) {
            super(writeRequest);
        }

        @Override
        public Object getMessage() {
            return EMPTY_BUFFER;
        }
    }

    private static class EncodedWriteRequest
    extends DefaultWriteRequest {
        public EncodedWriteRequest(Object encodedMessage, WriteFuture future, SocketAddress destination) {
            super(encodedMessage, future, destination);
        }
    }
}

