/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.service.DefaultTransportMetadata;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.IoServiceListenerSupport;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.write.WriteRequestQueue;
import org.apache.mina.transport.vmpipe.DefaultVmPipeSessionConfig;
import org.apache.mina.transport.vmpipe.VmPipe;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeFilterChain;
import org.apache.mina.transport.vmpipe.VmPipeSessionConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VmPipeSession
extends AbstractIoSession {
    static final TransportMetadata METADATA = new DefaultTransportMetadata("mina", "vmpipe", false, false, VmPipeAddress.class, VmPipeSessionConfig.class, Object.class);
    private static final VmPipeSessionConfig CONFIG = new DefaultVmPipeSessionConfig();
    private final IoService service;
    private final IoServiceListenerSupport serviceListeners;
    private final VmPipeAddress localAddress;
    private final VmPipeAddress remoteAddress;
    private final VmPipeAddress serviceAddress;
    private final IoHandler handler;
    private final VmPipeFilterChain filterChain;
    private final VmPipeSession remoteSession;
    private final Lock lock;
    final BlockingQueue<Object> receivedMessageQueue;

    VmPipeSession(IoService service, IoServiceListenerSupport serviceListeners, VmPipeAddress localAddress, IoHandler handler, VmPipe remoteEntry) {
        this.service = service;
        this.serviceListeners = serviceListeners;
        this.lock = new ReentrantLock();
        this.localAddress = localAddress;
        this.remoteAddress = this.serviceAddress = remoteEntry.getAddress();
        this.handler = handler;
        this.filterChain = new VmPipeFilterChain(this);
        this.receivedMessageQueue = new LinkedBlockingQueue<Object>();
        this.remoteSession = new VmPipeSession(this, remoteEntry);
    }

    private VmPipeSession(VmPipeSession remoteSession, VmPipe entry) {
        this.service = entry.getAcceptor();
        this.serviceListeners = entry.getListeners();
        this.lock = remoteSession.lock;
        this.localAddress = this.serviceAddress = remoteSession.remoteAddress;
        this.remoteAddress = remoteSession.localAddress;
        this.handler = entry.getHandler();
        this.filterChain = new VmPipeFilterChain(this);
        this.remoteSession = remoteSession;
        this.receivedMessageQueue = new LinkedBlockingQueue<Object>();
    }

    @Override
    public IoService getService() {
        return this.service;
    }

    @Override
    public IoProcessor<VmPipeSession> getProcessor() {
        return this.filterChain.getProcessor();
    }

    IoServiceListenerSupport getServiceListeners() {
        return this.serviceListeners;
    }

    @Override
    public VmPipeSessionConfig getConfig() {
        return CONFIG;
    }

    @Override
    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    public VmPipeSession getRemoteSession() {
        return this.remoteSession;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return METADATA;
    }

    @Override
    public VmPipeAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public VmPipeAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public VmPipeAddress getServiceAddress() {
        return this.serviceAddress;
    }

    void increaseWrittenBytes0(int increment, long currentTime) {
        super.increaseWrittenBytes(increment, currentTime);
    }

    WriteRequestQueue getWriteRequestQueue0() {
        return super.getWriteRequestQueue();
    }

    Lock getLock() {
        return this.lock;
    }
}

