/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionAttributeMap;
import org.apache.mina.core.session.IoSessionDataStructureFactory;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestQueue;
import org.apache.mina.util.CircularQueue;

public class DefaultIoSessionDataStructureFactory
implements IoSessionDataStructureFactory {
    public IoSessionAttributeMap getAttributeMap(IoSession session) throws Exception {
        return new DefaultIoSessionAttributeMap();
    }

    public WriteRequestQueue getWriteRequestQueue(IoSession session) throws Exception {
        return new DefaultWriteRequestQueue();
    }

    private static class DefaultWriteRequestQueue
    implements WriteRequestQueue {
        private final Queue<WriteRequest> q = new CircularQueue<WriteRequest>(16);

        public void dispose(IoSession session) {
        }

        public void clear(IoSession session) {
            this.q.clear();
        }

        public synchronized boolean isEmpty(IoSession session) {
            return this.q.isEmpty();
        }

        public synchronized void offer(IoSession session, WriteRequest writeRequest) {
            this.q.offer(writeRequest);
        }

        public synchronized WriteRequest poll(IoSession session) {
            Object message;
            WriteRequest request = this.q.poll();
            if (request != null && (message = request.getMessage()) instanceof IoBuffer) {
                ((IoBuffer)message).mark();
            }
            return request;
        }

        public String toString() {
            return this.q.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultIoSessionAttributeMap
    implements IoSessionAttributeMap {
        private final Map<Object, Object> attributes = Collections.synchronizedMap(new HashMap(4));

        @Override
        public Object getAttribute(IoSession session, Object key, Object defaultValue) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            Object answer = this.attributes.get(key);
            if (answer == null) {
                return defaultValue;
            }
            return answer;
        }

        @Override
        public Object setAttribute(IoSession session, Object key, Object value) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (value == null) {
                return this.attributes.remove(key);
            }
            return this.attributes.put(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object setAttributeIfAbsent(IoSession session, Object key, Object value) {
            Object oldValue;
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (value == null) {
                return null;
            }
            Map<Object, Object> map = this.attributes;
            synchronized (map) {
                oldValue = this.attributes.get(key);
                if (oldValue == null) {
                    this.attributes.put(key, value);
                }
            }
            return oldValue;
        }

        @Override
        public Object removeAttribute(IoSession session, Object key) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            return this.attributes.remove(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAttribute(IoSession session, Object key, Object value) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (value == null) {
                return false;
            }
            Map<Object, Object> map = this.attributes;
            synchronized (map) {
                if (value.equals(this.attributes.get(key))) {
                    this.attributes.remove(key);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replaceAttribute(IoSession session, Object key, Object oldValue, Object newValue) {
            Map<Object, Object> map = this.attributes;
            synchronized (map) {
                Object actualOldValue = this.attributes.get(key);
                if (actualOldValue == null) {
                    return false;
                }
                if (actualOldValue.equals(oldValue)) {
                    this.attributes.put(key, newValue);
                    return true;
                }
                return false;
            }
        }

        @Override
        public boolean containsAttribute(IoSession session, Object key) {
            return this.attributes.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Object> getAttributeKeys(IoSession session) {
            Map<Object, Object> map = this.attributes;
            synchronized (map) {
                return new HashSet<Object>(this.attributes.keySet());
            }
        }

        @Override
        public void dispose(IoSession session) throws Exception {
        }
    }
}

