/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.ssl.cert;

import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.x500.X500Principal;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.Comparators;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ssl.SslResourceAddress;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.ssl.bridge.filter.SslCertificateSelectionFilter;
import org.kaazing.gateway.transport.ssl.cert.AbstractKeySelector;
import org.kaazing.gateway.transport.ssl.cert.CertificateNotAvailableException;
import org.kaazing.gateway.transport.ssl.cert.CertificateNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualHostKeySelector
extends AbstractKeySelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualHostKeySelector.class);
    private Map<String, Collection<String>> hostnameToCertAliases = new HashMap<String, Collection<String>>();
    private Map<ResourceAddress, Collection<String>> transportAddressToCertAliases = new TreeMap<ResourceAddress, Collection<String>>(Comparators.compareResourceOriginPathAlternatesAndProtocolStack());
    private Map<ResourceAddress, List<ResourceAddress>> transportAddressToResourceAddresses = new TreeMap<ResourceAddress, List<ResourceAddress>>(Comparators.compareResourceOriginAndProtocolStack());
    private Map<String, String> aliasToCertCN = new HashMap<String, String>();

    @Override
    public ResourceAddress getAvailableCertAliasesKey(boolean clientMode) {
        IoSession session = SslCertificateSelectionFilter.getCurrentSession(clientMode);
        if (session == null) {
            return null;
        }
        if (clientMode) {
            return (ResourceAddress)BridgeSession.REMOTE_ADDRESS.get(session);
        }
        return (ResourceAddress)BridgeSession.LOCAL_ADDRESS.get(session);
    }

    @Override
    public Collection<String> getAvailableCertAliases(boolean clientMode) {
        return this.transportAddressToCertAliases.get(this.getAvailableCertAliasesKey(clientMode));
    }

    private String getCertCN(X509Certificate x509) throws CertificateParsingException {
        String[] fields;
        X500Principal principal = x509.getSubjectX500Principal();
        String subjectName = principal.getName();
        for (String field : fields = subjectName.split(",")) {
            if (!field.startsWith("CN=")) continue;
            String serverName = field.substring(3);
            return serverName.toLowerCase();
        }
        throw new CertificateParsingException("Certificate CN not found");
    }

    private Collection<String> getCertServerNames(X509Certificate x509) throws CertificateParsingException {
        LinkedHashSet<String> serverNames = new LinkedHashSet<String>();
        String certCN = this.getCertCN(x509);
        serverNames.add(certCN);
        try {
            Collection<List<?>> altNames = x509.getSubjectAlternativeNames();
            if (altNames != null) {
                for (List<?> entry : altNames) {
                    Object field;
                    Object entryType;
                    if (entry.size() < 2 || !((entryType = entry.get(0)) instanceof Integer) || (Integer)entryType != 2 || !((field = entry.get(1)) instanceof String)) continue;
                    serverNames.add(((String)field).toLowerCase());
                }
            }
        }
        catch (CertificateParsingException cpe) {
            LOGGER.warn("Certificate alternative names ignored for certificate " + (certCN != null ? " " + certCN : ""), (Throwable)cpe);
        }
        return serverNames;
    }

    @Override
    public void init(KeyStore keyStore, char[] keyStorePassword) throws KeyStoreException {
        if (keyStore == null) {
            return;
        }
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate cert;
            String alias = aliases.nextElement();
            if (!keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) || !((cert = keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
            try {
                X509Certificate x509 = (X509Certificate)cert;
                String certCN = this.getCertCN(x509);
                this.aliasToCertCN.put(alias, certCN);
                try {
                    x509.checkValidity();
                }
                catch (CertificateExpiredException cee) {
                    LOGGER.warn("The certificate associated with alias " + alias + " in the keystore is expired.");
                }
                catch (CertificateNotYetValidException cnyve) {
                    LOGGER.warn("The certificate associated with alias " + alias + " in the keystore is not yet valid.");
                }
                PublicKey pubKey = x509.getPublicKey();
                if (pubKey.getAlgorithm().equals("DSA")) {
                    LOGGER.warn(String.format("The certificate associated with alias %s is a DSA certificate.  DSA certificates require Diffie-Hellman ciphersuites, which do not provide authentication.  Search 'ssl.ciphers' in the documentation for details.", alias));
                }
                Collection<String> serverNames = this.getCertServerNames(x509);
                for (String serverName : serverNames) {
                    Collection<String> serverCertAliases = this.hostnameToCertAliases.get(serverName);
                    if (serverCertAliases == null) {
                        serverCertAliases = new HashSet<String>();
                        this.hostnameToCertAliases.put(serverName, serverCertAliases);
                    }
                    if (!serverCertAliases.add(alias)) continue;
                    String msg = "Found certificate for " + serverName + " (alias: " + alias + ")";
                    LOGGER.debug(msg);
                }
            }
            catch (CertificateParsingException cpe) {
                LOGGER.warn("The certificate associated with alias " + alias + " was ignored due to a parsing exceptions", (Throwable)cpe);
            }
        }
    }

    @Override
    public void bind(ResourceAddress resourceAddress) throws Exception {
        String wildcard;
        Collection<String> wildcardCertAliases;
        URI resourceURI = resourceAddress.getResource();
        String serverName = resourceURI.getHost();
        ResourceAddress transport = resourceAddress.getTransport();
        assert (transport != null);
        URI transportURI = transport.getResource();
        if (serverName == null) {
            throw new CertificateNotFoundException("Unable to determine server name or address");
        }
        Collection<String> hostnameCertAliases = this.hostnameToCertAliases.get(serverName);
        if (hostnameCertAliases == null) {
            hostnameCertAliases = new HashSet<String>();
        }
        if (serverName.contains(".") && (wildcardCertAliases = this.hostnameToCertAliases.get(wildcard = serverName.replaceFirst("[^.]+", "*"))) != null) {
            hostnameCertAliases.addAll(wildcardCertAliases);
        }
        if (hostnameCertAliases.isEmpty()) {
            String msg = "Keystore does not have a certificate entry for " + serverName;
            LOGGER.error(msg);
            throw new CertificateNotFoundException(msg);
        }
        Collection<String> transportAddressCertAliases = this.transportAddressToCertAliases.get(transport);
        if (transportAddressCertAliases == null) {
            transportAddressCertAliases = new HashSet<String>(hostnameCertAliases);
            this.transportAddressToCertAliases.put(transport, transportAddressCertAliases);
        } else {
            String msg;
            String certCN;
            HashSet<String> conflictingAliases;
            if (!hostnameCertAliases.containsAll(transportAddressCertAliases)) {
                conflictingAliases = new HashSet<String>(hostnameCertAliases);
                conflictingAliases.removeAll(transportAddressCertAliases);
                for (String conflictingAlias : conflictingAliases) {
                    certCN = this.aliasToCertCN.get(conflictingAlias);
                    msg = String.format("A certificate for %s (alias %s) cannot be used on transport %s, because it does not match all possible hostnames bound to that port", certCN, conflictingAlias, transportURI);
                    LOGGER.warn(msg);
                }
            }
            if (!transportAddressCertAliases.containsAll(hostnameCertAliases)) {
                conflictingAliases = new HashSet<String>(transportAddressCertAliases);
                conflictingAliases.removeAll(hostnameCertAliases);
                for (String conflictingAlias : conflictingAliases) {
                    certCN = this.aliasToCertCN.get(conflictingAlias);
                    msg = String.format("A certificate for %s (alias %s) cannot be used on transport %s, because it does not match all possible hostnames bound to that port", certCN, conflictingAlias, transportURI);
                    LOGGER.warn(msg);
                }
                transportAddressCertAliases.retainAll(hostnameCertAliases);
                if (transportAddressCertAliases.isEmpty()) {
                    String msg2 = String.format("keystore does not have any certificate entries matching all possible hostnames bound to %s", transportURI);
                    LOGGER.error(msg2);
                    throw new CertificateNotAvailableException(msg2);
                }
            }
        }
        List<ResourceAddress> transportAddressResourceAddresses = this.transportAddressToResourceAddresses.get(transport);
        if (transportAddressResourceAddresses == null) {
            transportAddressResourceAddresses = new LinkedList<ResourceAddress>();
            transportAddressResourceAddresses.add(resourceAddress);
            this.transportAddressToResourceAddresses.put(transport, transportAddressResourceAddresses);
        } else {
            ResourceAddress boundAddress = transportAddressResourceAddresses.get(0);
            boolean boundWantClientAuth = (Boolean)boundAddress.getOption(SslResourceAddress.WANT_CLIENT_AUTH);
            boolean boundNeedClientAuth = (Boolean)boundAddress.getOption(SslResourceAddress.NEED_CLIENT_AUTH);
            boolean bindWantClientAuth = (Boolean)resourceAddress.getOption(SslResourceAddress.WANT_CLIENT_AUTH);
            boolean bindNeedClientAuth = (Boolean)resourceAddress.getOption(SslResourceAddress.NEED_CLIENT_AUTH);
            if (boundWantClientAuth != bindWantClientAuth || boundNeedClientAuth != bindNeedClientAuth) {
                URI boundURI = boundAddress.getResource();
                URI bindURI = resourceAddress.getResource();
                String msg = String.format("<ssl.verify-client> value for <accept>%s</accept> does not match <ssl.verify-client> value for <accept>%s</accept> on same transport %s", bindURI, boundURI, transportURI);
                LOGGER.error(msg);
                throw new CertificateException(msg);
            }
            Object[] boundCiphers = (String[])boundAddress.getOption(SslResourceAddress.CIPHERS);
            Object[] bindCiphers = (String[])resourceAddress.getOption(SslResourceAddress.CIPHERS);
            Arrays.sort(bindCiphers);
            Arrays.sort(boundCiphers);
            if (!Arrays.equals(boundCiphers, bindCiphers)) {
                URI boundURI = boundAddress.getResource();
                URI bindURI = resourceAddress.getResource();
                String msg = String.format("<ssl.ciphers>%s</ssl.ciphers> value for %s does not match <ssl.ciphers>%s</ssl.ciphers> also configured for %s on same transport %s", Arrays.asList(bindCiphers), bindURI, Arrays.asList(boundCiphers), boundURI, transportURI);
                LOGGER.error(msg);
                throw new CertificateException(msg);
            }
            Object[] boundProtocols = (String[])boundAddress.getOption(SslResourceAddress.PROTOCOLS);
            Object[] bindProtocols = (String[])resourceAddress.getOption(SslResourceAddress.PROTOCOLS);
            if (bindProtocols != null) {
                Arrays.sort(bindProtocols);
            }
            if (boundProtocols != null) {
                Arrays.sort(boundProtocols);
            }
            if (!Arrays.equals(boundProtocols, bindProtocols)) {
                URI boundURI = boundAddress.getResource();
                URI bindURI = resourceAddress.getResource();
                String msg = String.format("<ssl.protocols>%s</ssl.protocols> value for %s does not match <ssl.protocols>%s</ssl.protocols> also configured for %s on same transport %s", bindProtocols == null ? null : Arrays.asList(bindProtocols), bindURI, boundProtocols == null ? null : Arrays.asList(boundProtocols), boundURI, transportURI);
                LOGGER.error(msg);
                throw new CertificateException(msg);
            }
            transportAddressResourceAddresses.add(resourceAddress);
        }
    }

    @Override
    public void unbind(ResourceAddress resourceAddress) {
        List<ResourceAddress> inetAddressResourceAddresses = this.transportAddressToResourceAddresses.get(resourceAddress.getTransport());
        if (inetAddressResourceAddresses != null) {
            this.transportAddressToResourceAddresses.remove(resourceAddress.getTransport());
        }
    }
}

