/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.ssl;

import javax.net.ssl.SSLException;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.ssl.SslResourceAddress;
import org.kaazing.gateway.transport.AbstractBridgeSession;
import org.kaazing.gateway.transport.BridgeConnectProcessor;
import org.kaazing.gateway.transport.ssl.SslSession;
import org.kaazing.gateway.transport.ssl.bridge.filter.SslFilter;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslConnectProcessor
extends BridgeConnectProcessor<SslSession> {
    private final Logger logger = LoggerFactory.getLogger((String)"transport.ssl");

    protected void removeInternal(SslSession session) {
        try {
            SslFilter sslFilter;
            IoSessionEx parent;
            IoFilterChain filterChain;
            IoFilterChain.Entry entry;
            boolean isSslEncryptionEnabled = (Boolean)session.getRemoteAddress().getOption(SslResourceAddress.ENCRYPTION_ENABLED);
            if (isSslEncryptionEnabled && (entry = (filterChain = (parent = session.getParent()).getFilterChain()).getEntry(SslFilter.class)) != null && (sslFilter = (SslFilter)entry.getFilter()).isSslStarted((IoSession)parent)) {
                sslFilter.stopSsl((IoSession)parent);
                return;
            }
        }
        catch (SSLException e) {
            this.logger.debug("Ignoring message during SSL shutdown due to closing session", (Throwable)e);
        }
        super.removeInternal((AbstractBridgeSession)session);
    }
}

