/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.ssl;

import java.io.IOException;
import java.net.URI;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslContextFactory;
import org.kaazing.gateway.resource.address.Protocol;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactory;
import org.kaazing.gateway.resource.address.ResourceOptions;
import org.kaazing.gateway.resource.address.ssl.SslResourceAddress;
import org.kaazing.gateway.security.KeySelector;
import org.kaazing.gateway.security.SecurityContext;
import org.kaazing.gateway.transport.AbstractBridgeAcceptor;
import org.kaazing.gateway.transport.Bindings;
import org.kaazing.gateway.transport.BridgeAcceptor;
import org.kaazing.gateway.transport.BridgeServiceFactory;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.BridgeSessionInitializer;
import org.kaazing.gateway.transport.BridgeSessionInitializerAdapter;
import org.kaazing.gateway.transport.DefaultIoSessionConfigEx;
import org.kaazing.gateway.transport.DefaultTransportMetadata;
import org.kaazing.gateway.transport.IoHandlerAdapter;
import org.kaazing.gateway.transport.NextProtocolBindings;
import org.kaazing.gateway.transport.NextProtocolFilter;
import org.kaazing.gateway.transport.NioBindException;
import org.kaazing.gateway.transport.TransportKeySelector;
import org.kaazing.gateway.transport.TypedAttributeKey;
import org.kaazing.gateway.transport.ssl.SslAcceptProcessor;
import org.kaazing.gateway.transport.ssl.SslProvider;
import org.kaazing.gateway.transport.ssl.SslSession;
import org.kaazing.gateway.transport.ssl.bridge.filter.SslCertificateSelectionFilter;
import org.kaazing.gateway.transport.ssl.bridge.filter.SslFilter;
import org.kaazing.gateway.transport.ssl.cert.VirtualHostKeySelector;
import org.kaazing.gateway.util.ssl.SslCipherSuites;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.future.UnbindFuture;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.service.IoServiceEx;
import org.kaazing.mina.core.session.IoSessionConfigEx;
import org.kaazing.mina.core.session.IoSessionEx;

public class SslAcceptor
extends AbstractBridgeAcceptor<SslSession, NextProtocolBindings.NextProtocolBinding> {
    private static final TypedAttributeKey<SslSession> SESSION_KEY = new TypedAttributeKey(SslAcceptor.class, "session");
    private static final String CODEC_FILTER = "ssl#codec";
    private static final String CERTIFICATE_SELECTION_FILTER = "ssl#certificate_selection";
    private static final String CIPHER_SELECTION_FILTER = "ssl#cipher_selection";
    public static final String CLIENT_HELLO_CODEC_FILTER = "ssl#client_hello_codec";
    private static final String NEXT_PROTOCOL_FILTER = "ssl#nextProtocol";
    private static final String ENCRYPTION_DISABLED_FILTER = "ssl#encryption_disabled";
    private SSLContext sslContext;
    private SslContextFactory sslContextFactory;
    private SslCertificateSelectionFilter certificateSelection;
    private ResourceAddressFactory resourceAddressFactory;
    private BridgeServiceFactory bridgeServiceFactory;
    private VirtualHostKeySelector vhostKeySelector;
    private IoHandler secureBridgeHandler = new BridgeHandler(true);
    private BridgeHandler unsecureBridgeHandler = new BridgeHandler(false);
    @Deprecated
    public static final TypedAttributeKey<ResourceAddress> SSL_RESOURCE_ADDRESS = new TypedAttributeKey(SslFilter.class, "sslResourceAddress");

    public SslAcceptor() {
        super((IoSessionConfigEx)new DefaultIoSessionConfigEx());
    }

    @Resource(name="bridgeServiceFactory")
    public void setBridgeServiceFactory(BridgeServiceFactory bridgeServiceFactory) {
        this.bridgeServiceFactory = bridgeServiceFactory;
    }

    @Resource(name="resourceAddressFactory")
    public void setResourceAddressFactory(ResourceAddressFactory factory) {
        this.resourceAddressFactory = factory;
    }

    @Resource(name="securityContext")
    public void setSecurityContext(SecurityContext securityContext) {
        this.vhostKeySelector = new VirtualHostKeySelector();
        try {
            this.vhostKeySelector.init(securityContext.getKeyStore(), securityContext.getKeyStorePassword());
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        try {
            this.sslContextFactory = new SslContextFactory();
            this.sslContextFactory.setTrustManagerFactoryKeyStore(securityContext.getTrustStore());
            char[] keyStorePassword = securityContext.getKeyStorePassword();
            this.sslContextFactory.setKeyManagerFactoryKeyStorePassword(keyStorePassword == null ? null : new String(keyStorePassword));
            this.sslContextFactory.setKeyManagerFactoryKeyStore(securityContext.getKeyStore());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SslTransport", new SslProvider());
            this.sslContextFactory.setKeyManagerFactory(kmf);
            this.sslContextFactory.setServerSessionCacheSize(1);
        }
        catch (NoSuchAlgorithmException ne) {
            throw new RuntimeException(ne);
        }
    }

    public TransportMetadata getTransportMetadata() {
        return new DefaultTransportMetadata("ssl");
    }

    protected void init() {
        super.init();
        try {
            this.sslContext = this.sslContextFactory.newInstance();
        }
        catch (UnrecoverableKeyException uke) {
            throw new RuntimeException("Unable to load necessary certificate keys from keystore; perhaps your keys are protected by passwords that are different from the keystore password?", uke);
        }
        catch (Exception e) {
            this.logger.error("Exception while creating SSL context: ", (Throwable)e);
        }
        this.certificateSelection = new SslCertificateSelectionFilter(false);
    }

    protected Bindings<NextProtocolBindings.NextProtocolBinding> initBindings() {
        return new NextProtocolBindings();
    }

    protected IoProcessorEx<SslSession> initProcessor() {
        return new SslAcceptProcessor();
    }

    public void addBridgeFilters(IoFilterChain filterChain) {
        NextProtocolBindings.NextProtocolBinding sslBinding;
        SslFilter sslFilter = new SslFilter(this.sslContext, false, this.logger);
        IoSession session = filterChain.getSession();
        ResourceAddress sslAddress = (ResourceAddress)SSL_RESOURCE_ADDRESS.get(session);
        boolean encryption = (Boolean)sslAddress.getOption(SslResourceAddress.ENCRYPTION_ENABLED);
        if (encryption) {
            boolean wantClientAuth = (Boolean)sslAddress.getOption(SslResourceAddress.WANT_CLIENT_AUTH);
            boolean needClientAuth = (Boolean)sslAddress.getOption(SslResourceAddress.NEED_CLIENT_AUTH);
            List<String> unresolvedCipherNames = this.toCipherList((String[])sslAddress.getOption(SslResourceAddress.CIPHERS));
            List resolvedCipherNames = SslCipherSuites.resolve(unresolvedCipherNames);
            String[] enabledCipherSuites = resolvedCipherNames.toArray(new String[resolvedCipherNames.size()]);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(String.format("Configured SSL/TLS ciphersuites:\n  %s", this.toCipherString(this.toCipherList(enabledCipherSuites))));
            }
            sslFilter.setWantClientAuth(wantClientAuth);
            sslFilter.setNeedClientAuth(needClientAuth);
            sslFilter.setEnabledCipherSuites(enabledCipherSuites);
            sslFilter.setEnabledProtocols((String[])sslAddress.getOption(SslResourceAddress.PROTOCOLS));
            IoSessionEx sessionEx = (IoSessionEx)session;
            IoBufferAllocatorEx allocator = sessionEx.getBufferAllocator();
            filterChain.addFirst(CERTIFICATE_SELECTION_FILTER, (IoFilter)this.certificateSelection);
            filterChain.addAfter(CERTIFICATE_SELECTION_FILTER, CODEC_FILTER, (IoFilter)sslFilter);
        }
        if ((sslBinding = (NextProtocolBindings.NextProtocolBinding)this.bindings.getBinding0(sslAddress)) == null) {
            session.close(true);
            return;
        }
        SortedSet nextProtocolNames = sslBinding.getNextProtocolNames();
        if (nextProtocolNames.isEmpty()) {
            BridgeSession.NEXT_PROTOCOL_KEY.set(session, null);
        } else if (nextProtocolNames.size() == 1) {
            BridgeSession.NEXT_PROTOCOL_KEY.set(session, nextProtocolNames.first());
        } else {
            Collection dispatchers = this.bridgeServiceFactory.getTransportFactory().getProtocolDispatchers().values();
            filterChain.addLast(NEXT_PROTOCOL_FILTER, (IoFilter)new NextProtocolFilter(dispatchers));
        }
        if (!encryption) {
            filterChain.addLast(ENCRYPTION_DISABLED_FILTER, (IoFilter)new EncryptionDisabledFilter());
        }
    }

    private List<String> toCipherList(String[] names) {
        if (names == null || names.length == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(names.length);
        Collections.addAll(list, names);
        return list;
    }

    private String toCipherString(List<String> names) {
        if (names == null || names.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            sb.append("  ").append(name).append("\n");
        }
        String cipherString = sb.toString().trim();
        return cipherString;
    }

    public void removeBridgeFilters(IoFilterChain filterChain) {
        this.removeFilter(filterChain, CODEC_FILTER);
        this.removeFilter(filterChain, CIPHER_SELECTION_FILTER);
        this.removeFilter(filterChain, CLIENT_HELLO_CODEC_FILTER);
        this.removeFilter(filterChain, CERTIFICATE_SELECTION_FILTER);
        this.removeFilter(filterChain, NEXT_PROTOCOL_FILTER);
    }

    protected boolean canBind(String transportName) {
        return transportName.equals("ssl");
    }

    protected <T extends IoFuture> void bindInternal(final ResourceAddress address, IoHandler handler, BridgeSessionInitializer<T> initializer) {
        boolean sslEncryptionEnabled = (Boolean)address.getOption(SslResourceAddress.ENCRYPTION_ENABLED);
        if (sslEncryptionEnabled) {
            try {
                Object keySelector = (KeySelector)address.getOption(SslResourceAddress.KEY_SELECTOR);
                if (keySelector == null) {
                    keySelector = this.vhostKeySelector;
                }
                TransportKeySelector transportKeySelector = (TransportKeySelector)TransportKeySelector.class.cast(keySelector);
                this.certificateSelection.setKeySelector(transportKeySelector);
                transportKeySelector.bind(address);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ResourceAddress transport = address.getTransport();
        assert (transport != null);
        Object bridgeHandler = sslEncryptionEnabled ? this.secureBridgeHandler : this.unsecureBridgeHandler;
        ResourceAddress transportAddress = transport;
        BridgeAcceptor acceptor = this.bridgeServiceFactory.newBridgeAcceptor(transportAddress);
        try {
            URI transportURI = transportAddress.getResource();
            Protocol transportProtocol = this.bridgeServiceFactory.getTransportFactory().getProtocol(transportURI.getScheme());
            final BridgeSessionInitializer parentInitializer = initializer != null ? initializer.getParentInitializer(transportProtocol) : null;
            BridgeSessionInitializerAdapter wrapperInitializer = new BridgeSessionInitializerAdapter<T>(){

                public void initializeSession(IoSession session, T future) {
                    SSL_RESOURCE_ADDRESS.set(session, (Object)address);
                    if (parentInitializer != null) {
                        parentInitializer.initializeSession(session, future);
                    }
                }
            };
            acceptor.bind(transportAddress, bridgeHandler, (BridgeSessionInitializer)wrapperInitializer);
        }
        catch (NioBindException e) {
            Iterable failedAddresses = e.getFailedAddresses();
            for (ResourceAddress failedAddress : failedAddresses) {
                IoHandler existingHandler = acceptor.getHandler(failedAddress);
                if (existingHandler != this.secureBridgeHandler) continue;
                throw new RuntimeException(failedAddress + " is configured as a secure port in a service already and cannot be bound as an unsecure port in service: " + address, e);
            }
            throw new RuntimeException("Unable to bind address " + failedAddresses.iterator().next() + ": " + e.getMessage(), e);
        }
    }

    protected UnbindFuture unbindInternal(ResourceAddress address, IoHandler handler, BridgeSessionInitializer<? extends IoFuture> initializer) {
        ResourceAddress transport = address.getTransport();
        assert (transport != null);
        ResourceAddress transportAddress = address.getTransport();
        boolean sslEncryptionEnabled = (Boolean)address.getOption(SslResourceAddress.ENCRYPTION_ENABLED);
        if (sslEncryptionEnabled) {
            try {
                Object keySelector = (KeySelector)address.getOption(SslResourceAddress.KEY_SELECTOR);
                if (keySelector == null) {
                    keySelector = this.vhostKeySelector;
                }
                TransportKeySelector transportKeySelector = (TransportKeySelector)TransportKeySelector.class.cast(keySelector);
                transportKeySelector.unbind(address);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        BridgeAcceptor acceptor = this.bridgeServiceFactory.newBridgeAcceptor(transportAddress);
        return acceptor.unbind(transportAddress);
    }

    private final class BridgeHandler
    extends IoHandlerAdapter<IoSessionEx> {
        private final boolean sslEncryptionEnabled;

        public BridgeHandler(boolean sslEncryptionEnabled) {
            this.sslEncryptionEnabled = sslEncryptionEnabled;
        }

        protected void doExceptionCaught(IoSessionEx session, Throwable cause) throws Exception {
            if (SslAcceptor.this.logger.isDebugEnabled()) {
                String message = String.format("Error on SSL connection, closing connection: %s", cause);
                if (SslAcceptor.this.logger.isTraceEnabled()) {
                    SslAcceptor.this.logger.debug(message, cause);
                } else {
                    SslAcceptor.this.logger.debug(message);
                }
            }
            session.close(true);
        }

        protected void doMessageReceived(IoSessionEx session, Object message) throws Exception {
            if (message == SslFilter.SESSION_SECURED) {
                IoFilterChain filterChain = session.getFilterChain();
                SslAcceptor.this.removeFilter(filterChain, (IoFilter)SslAcceptor.this.certificateSelection);
                IoSession sslSession = (IoSession)SESSION_KEY.get((IoSession)session);
                assert (sslSession == null);
                SslSession newSslSession = this.createSslSession(session);
                SESSION_KEY.set((IoSession)session, (Object)newSslSession);
            } else if (message == SslFilter.SESSION_UNSECURED) {
                SslSession sslSession = (SslSession)((Object)SESSION_KEY.remove((IoSession)session));
                if (sslSession != null && !sslSession.isClosing()) {
                    sslSession.getProcessor().remove((IoSession)sslSession);
                }
            } else {
                IoSession sslSession = (IoSession)SESSION_KEY.get((IoSession)session);
                assert (sslSession != null);
                IoFilterChain filterChain = sslSession.getFilterChain();
                filterChain.fireMessageReceived(message);
            }
        }

        private SslSession createSslSession(final IoSessionEx session) throws Exception {
            SslSession sslSession = (SslSession)SslAcceptor.this.newSession(null, new Callable<SslSession>(){

                @Override
                public SslSession call() {
                    ResourceAddress localSslAddress = this.getSslSessionLocalAddress((IoSession)session);
                    ResourceAddress remoteSslAddress = this.getSslSessionRemoteAddress((IoSession)session, localSslAddress);
                    SslSession newSslSession = new SslSession((IoServiceEx)SslAcceptor.this, (IoProcessorEx<SslSession>)SslAcceptor.this.getProcessor(), localSslAddress, remoteSslAddress, session);
                    IoHandler handler = SslAcceptor.this.getHandler(newSslSession.getLocalAddress());
                    newSslSession.setHandler(handler);
                    return newSslSession;
                }

                private ResourceAddress getSslSessionLocalAddress(IoSession session2) {
                    ResourceAddress boundAddress = (ResourceAddress)SSL_RESOURCE_ADDRESS.remove(session2);
                    assert (boundAddress != null);
                    String candidateURI = boundAddress.getExternalURI();
                    ResourceOptions candidateOptions = ResourceOptions.FACTORY.newResourceOptions((ResourceOptions)boundAddress);
                    candidateOptions.setOption(ResourceAddress.NEXT_PROTOCOL, BridgeSession.NEXT_PROTOCOL_KEY.get(session2));
                    candidateOptions.setOption(ResourceAddress.TRANSPORT, BridgeSession.LOCAL_ADDRESS.get(session2));
                    ResourceAddress candidateAddress = SslAcceptor.this.resourceAddressFactory.newResourceAddress(candidateURI, candidateOptions);
                    Bindings.Binding binding = SslAcceptor.this.bindings.getBinding(candidateAddress);
                    return binding != null ? binding.bindAddress() : null;
                }

                private ResourceAddress getSslSessionRemoteAddress(IoSession session2, ResourceAddress localSslAddress) {
                    return SslAcceptor.this.resourceAddressFactory.newResourceAddress(localSslAddress, (ResourceAddress)BridgeSession.REMOTE_ADDRESS.get(session2));
                }
            });
            return sslSession;
        }

        protected void doSessionClosed(IoSessionEx session) throws Exception {
            SslSession sslSession = (SslSession)((Object)SESSION_KEY.remove((IoSession)session));
            if (sslSession != null) {
                if (sslSession.isClosing()) {
                    sslSession.getProcessor().remove((IoSession)sslSession);
                } else {
                    sslSession.reset(new IOException("Early termination of IO session").fillInStackTrace());
                }
            }
        }

        protected void doSessionIdle(IoSessionEx session, IdleStatus status) throws Exception {
            SslSession sslSession = (SslSession)((Object)SESSION_KEY.get((IoSession)session));
            if (sslSession != null) {
                IoFilterChain filterChain = sslSession.getFilterChain();
                filterChain.fireSessionIdle(status);
            }
        }

        protected void doSessionCreated(IoSessionEx session) throws Exception {
            session.setAttribute((Object)SslFilter.USE_NOTIFICATION);
            SslAcceptor.this.addBridgeFilters(session.getFilterChain());
        }
    }

    private final class EncryptionDisabledFilter
    extends IoFilterAdapter {
        private EncryptionDisabledFilter() {
        }

        public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
            SslSession sslSession = SslAcceptor.this.unsecureBridgeHandler.createSslSession((IoSessionEx)session);
            SESSION_KEY.set(session, (Object)sslSession);
            session.getFilterChain().remove((IoFilter)this);
            super.messageReceived(nextFilter, session, message);
        }
    }
}

