/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.util;

import org.kaazing.gateway.service.ServiceProperties;
import org.kaazing.gateway.util.Utils;

public class ServiceUtils {
    public static final String LIST_SEPARATOR = ",";

    public static String getRequiredProperty(ServiceProperties properties, String propertyName) {
        String propertyValue = properties.get(propertyName);
        if (propertyValue == null) {
            throw new IllegalStateException("Missing required property \"" + propertyName + "\"");
        }
        return propertyValue;
    }

    public static int getRequiredIntProperty(ServiceProperties properties, String propertyName) {
        return Integer.parseInt(ServiceUtils.getRequiredProperty(properties, propertyName));
    }

    public static float getRequiredFloatProperty(ServiceProperties properties, String propertyName) {
        return Float.parseFloat(ServiceUtils.getRequiredProperty(properties, propertyName));
    }

    public static String getOptionalProperty(ServiceProperties properties, String propertyName, String defaultValue) {
        String propertyValue = properties.get(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }

    public static int getOptionalIntProperty(ServiceProperties properties, String propertyName, int defaultValue) {
        return Integer.parseInt(ServiceUtils.getOptionalProperty(properties, propertyName, Integer.toString(defaultValue)));
    }

    public static long getOptionalLongProperty(ServiceProperties properties, String propertyName, long defaultValue) {
        return Long.parseLong(ServiceUtils.getOptionalProperty(properties, propertyName, Long.toString(defaultValue)));
    }

    public static boolean getOptionalBooleanProperty(ServiceProperties properties, String propertyName, boolean defaultValue) {
        return Boolean.parseBoolean(ServiceUtils.getOptionalProperty(properties, propertyName, Boolean.toString(defaultValue)));
    }

    public static int getOptionalDataSizeProperty(ServiceProperties properties, String propertyName, int defaultValue) {
        String value = ServiceUtils.getOptionalProperty(properties, propertyName, Integer.toString(defaultValue));
        return Utils.parseDataSize((String)value);
    }
}

