/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.cluster;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class EntryListenerSupport<K, V>
implements EntryListener<K, V> {
    private List<EntryListenerEntry<K, V>> listenerEntries = new CopyOnWriteArrayList<EntryListenerEntry<K, V>>();

    public void addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        this.listenerEntries.add(new EntryListenerEntry<K, V>(listener, key, includeValue));
    }

    public void removeEntryListener(EntryListener<K, V> listener, Object key) {
        EntryListenerEntry<K, V> entry = this.getListenerEntry(listener, key);
        if (entry != null) {
            this.listenerEntries.remove(entry);
        }
    }

    public void addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        this.listenerEntries.add(new EntryListenerEntry<K, V>(listener, includeValue));
    }

    public void removeEntryListener(EntryListener<K, V> listener) {
        this.listenerEntries.remove(listener);
    }

    public void entryAdded(EntryEvent<K, V> event) {
        this.entryMethod(event, Method.ADDED);
    }

    public void entryEvicted(EntryEvent<K, V> event) {
        this.entryMethod(event, Method.EVICTED);
    }

    public void entryRemoved(EntryEvent<K, V> event) {
        this.entryMethod(event, Method.REMOVED);
    }

    public void entryUpdated(EntryEvent<K, V> event) {
        this.entryMethod(event, Method.UPDATED);
    }

    private void entryMethod(EntryEvent<K, V> event, Method method) {
        EntryEvent copyNoValue = new EntryEvent((Object)event.getName(), null, event.getEventType().hashCode(), event.getKey(), null);
        for (EntryListenerEntry<K, V> listenerEntry : this.listenerEntries) {
            if (((EntryListenerEntry)listenerEntry).key != null && (event.getKey() == null || !((EntryListenerEntry)listenerEntry).key.equals(event.getKey()))) continue;
            switch (method) {
                case ADDED: {
                    ((EntryListenerEntry)listenerEntry).listener.entryAdded(((EntryListenerEntry)listenerEntry).includeValue ? event : copyNoValue);
                    break;
                }
                case REMOVED: {
                    ((EntryListenerEntry)listenerEntry).listener.entryRemoved(((EntryListenerEntry)listenerEntry).includeValue ? event : copyNoValue);
                    break;
                }
                case UPDATED: {
                    ((EntryListenerEntry)listenerEntry).listener.entryUpdated(((EntryListenerEntry)listenerEntry).includeValue ? event : copyNoValue);
                    break;
                }
                case EVICTED: {
                    ((EntryListenerEntry)listenerEntry).listener.entryEvicted(((EntryListenerEntry)listenerEntry).includeValue ? event : copyNoValue);
                }
            }
        }
    }

    private EntryListenerEntry<K, V> getListenerEntry(EntryListener<K, V> listener, Object key) {
        for (EntryListenerEntry<K, V> entry : this.listenerEntries) {
            if (!((EntryListenerEntry)entry).listener.equals(listener) || (((EntryListenerEntry)entry).key != null || key != null) && (((EntryListenerEntry)entry).key == null || key == null || !((EntryListenerEntry)entry).key.equals(key))) continue;
            return entry;
        }
        return null;
    }

    private static class EntryListenerEntry<K, V> {
        private EntryListener<K, V> listener;
        private Object key;
        private boolean includeValue;

        public EntryListenerEntry(EntryListener<K, V> listener, boolean includeValue) {
            this(listener, null, includeValue);
        }

        public EntryListenerEntry(EntryListener<K, V> listener, K key, boolean includeValue) {
            this.listener = listener;
            this.key = key;
            this.includeValue = includeValue;
        }
    }

    private static enum Method {
        ADDED,
        REMOVED,
        UPDATED,
        EVICTED;

    }
}

