/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.update.check.management;

import org.kaazing.gateway.management.update.check.ManagementUpdateCheck;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceFactory;
import org.kaazing.gateway.service.update.check.GatewayVersion;
import org.kaazing.gateway.service.update.check.UpdateCheckListener;
import org.kaazing.gateway.service.update.check.UpdateCheckService;

public class HttpManagementUpdateCheck
implements UpdateCheckListener,
ManagementUpdateCheck {
    private UpdateCheckService updateCheckService;
    private GatewayVersion latestVersion;

    public void newVersionAvailable(GatewayVersion currentVersion, GatewayVersion latestGatewayVersion) {
        if (this.latestVersion == null || this.latestVersion.compareTo(latestGatewayVersion) < 0) {
            this.latestVersion = latestGatewayVersion;
        }
    }

    public void checkForUpdate() {
        if (this.updateCheckService != null) {
            this.updateCheckService.checkForUpdate((UpdateCheckListener)this);
        } else {
            Service service = ServiceFactory.newServiceFactory().newService("update.check");
            if (service != null) {
                this.updateCheckService = (UpdateCheckService)service;
                this.updateCheckService.checkForUpdate((UpdateCheckListener)this);
            }
        }
    }

    public String getAvailableUpdateVersion() {
        return this.latestVersion != null ? this.latestVersion.toString() : "";
    }

    public void setUpdateCheckService(UpdateCheckService service) {
        this.updateCheckService = service;
    }
}

