/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.proxy;

import java.util.Collection;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.kaazing.gateway.service.proxy.AbstractProxyHandler;
import org.kaazing.gateway.service.proxy.DeferredConnectStrategyFilter;
import org.kaazing.gateway.service.proxy.ServiceConnectManager;
import org.kaazing.gateway.transport.BridgeServiceFactory;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.session.IoSessionEx;

public abstract class AbstractProxyAcceptHandler
extends AbstractProxyHandler {
    private AbstractProxyHandler connectHandler = this.createConnectHandler();
    private Collection<String> connectURIs;
    private ServiceConnectManager serviceConnectManager = null;

    protected AbstractProxyAcceptHandler() {
    }

    protected abstract AbstractProxyHandler createConnectHandler();

    protected AbstractProxyHandler getConnectHandler() {
        return this.connectHandler;
    }

    protected Collection<String> getConnectURIs() {
        return this.connectURIs;
    }

    public void setConnectURIs(Collection<String> connectURIs) {
        this.connectURIs = connectURIs;
    }

    public ServiceConnectManager getServiceConnectManager() {
        return this.serviceConnectManager;
    }

    public void initServiceConnectManager(BridgeServiceFactory bridgeServiceFactory) {
        String connectURI = this.connectURIs.iterator().next();
        this.serviceConnectManager = new ServiceConnectManager(this.getServiceContext(), this.getConnectHandler(), bridgeServiceFactory, connectURI, this.getMaximumRecoveryInterval(), this.getPreparedConnectionCount());
    }

    public void startServiceConnectManager() {
        this.serviceConnectManager.start();
    }

    public ConnectFuture getNextConnectFuture(IoSessionInitializer<ConnectFuture> connectInitializer) {
        return this.serviceConnectManager.getNextConnectFuture(connectInitializer);
    }

    @Override
    public void sessionCreated(IoSession session) {
        super.sessionCreated(session);
        if (this.isDeferredConnectStrategy()) {
            IoFilterChain filterChain = session.getFilterChain();
            filterChain.addLast("proxy#deferred", (IoFilter)new DeferredConnectStrategyFilter());
        }
    }

    public void sessionOpened(IoSession session) {
        this.initFilterChain(session, false);
    }

    protected void initFilterChain(IoSession session, boolean client) {
        IoFilterChain filterChain = session.getFilterChain();
        IoSessionEx sessionEx = (IoSessionEx)session;
        IoBufferAllocatorEx allocator = sessionEx.getBufferAllocator();
        filterChain.addLast("duplicate", (IoFilter)new AbstractProxyHandler.DuplicateBufferFilter(allocator));
    }

    @Override
    public void setMaximumPendingBytes(int maximumPendingBytes) {
        super.setMaximumPendingBytes(maximumPendingBytes);
        this.connectHandler.setMaximumPendingBytes(maximumPendingBytes);
    }
}

