/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.proxy;

import java.util.concurrent.ScheduledExecutorService;
import java.util.function.IntFunction;
import javax.annotation.Resource;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.ServiceProperties;
import org.kaazing.gateway.service.proxy.AbstractProxyHandler;
import org.kaazing.gateway.service.util.ServiceUtils;
import org.kaazing.gateway.util.scheduler.SchedulerProvider;

public abstract class AbstractProxyService<HandlerType extends AbstractProxyHandler>
implements Service {
    private static final String PROPERTY_MAXIMUM_PENDING_BYTES = "maximum.pending.bytes";
    private static final String PROPERTY_MAXIMUM_RECOVERY_INTERVAL = "maximum.recovery.interval";
    private static final String PROPERTY_PREPARED_CONNECTION_COUNT = "prepared.connection.count";
    private static final String PROPERTY_CONNECT_STRATEGY = "connect.strategy";
    private static final String PROPERTY_MAXIMUM_TRANSFERRED_BYTES = "internal.maximum.transferred.bytes";
    private static final int PROPERTY_MAXIMUM_PENDING_BYTES_DEFAULT = 64000;
    private static final int PROPERTY_MAXIMUM_RECOVERY_INTERVAL_DEFAULT = 0;
    private static final int PROPERTY_PREPARED_CONNECTION_COUNT_DEFAULT = 0;
    private static final int PROPERTY_MAXIMUM_TRANSFERRED_BYTES_DEFAULT = -1;
    private static final IntFunction<String> PROPERTY_CONNECT_STRATEGY_DEFAULT = count -> count > 0 ? "prepared" : "immediate";
    protected HandlerType handler;
    private ServiceContext serviceContext;
    protected ScheduledExecutorService scheduler;

    @Resource(name="schedulerProvider")
    public void setSchedulerProvider(SchedulerProvider provider) {
        this.scheduler = provider.getScheduler("Scheduler-AbstractProxyService", false);
    }

    public void init(ServiceContext serviceContext) throws Exception {
        this.serviceContext = serviceContext;
        ServiceProperties properties = serviceContext.getProperties();
        int maximumPendingBytes = ServiceUtils.getOptionalDataSizeProperty((ServiceProperties)properties, (String)PROPERTY_MAXIMUM_PENDING_BYTES, (int)64000);
        int maximumTransferredBytes = ServiceUtils.getOptionalDataSizeProperty((ServiceProperties)properties, (String)PROPERTY_MAXIMUM_TRANSFERRED_BYTES, (int)-1);
        int maximumRecoveryInterval = ServiceUtils.getOptionalIntProperty((ServiceProperties)properties, (String)PROPERTY_MAXIMUM_RECOVERY_INTERVAL, (int)0);
        int preparedConnectionCount = ServiceUtils.getOptionalIntProperty((ServiceProperties)properties, (String)PROPERTY_PREPARED_CONNECTION_COUNT, (int)0);
        String connectStrategy = ServiceUtils.getOptionalProperty((ServiceProperties)properties, (String)PROPERTY_CONNECT_STRATEGY, (String)PROPERTY_CONNECT_STRATEGY_DEFAULT.apply(preparedConnectionCount));
        this.handler = this.createHandler();
        ((AbstractProxyHandler)((Object)this.handler)).setServiceContext(serviceContext);
        ((AbstractProxyHandler)((Object)this.handler)).setMaximumPendingBytes(maximumPendingBytes);
        ((AbstractProxyHandler)((Object)this.handler)).setMaximumTransferredBytes(maximumTransferredBytes);
        ((AbstractProxyHandler)((Object)this.handler)).setMaximumRecoveryInterval(maximumRecoveryInterval);
        ((AbstractProxyHandler)((Object)this.handler)).setPreparedConnectionCount(connectStrategy, preparedConnectionCount, serviceContext.getProcessorCount());
    }

    public void start() throws Exception {
        this.serviceContext.bind(this.serviceContext.getAccepts(), this.handler);
        this.serviceContext.bindConnectsIfNecessary(this.serviceContext.getConnects());
    }

    public void stop() throws Exception {
        this.quiesce();
        this.serviceContext.unbindConnectsIfNecessary(this.serviceContext.getConnects());
        if (this.serviceContext != null) {
            for (IoSession session : this.serviceContext.getActiveSessions()) {
                session.close(true);
            }
        }
    }

    public void quiesce() throws Exception {
        if (this.serviceContext != null) {
            this.serviceContext.unbind(this.serviceContext.getAccepts(), this.handler);
        }
    }

    public void destroy() throws Exception {
    }

    protected abstract HandlerType createHandler();

    protected HandlerType getHandler() {
        return this.handler;
    }
}

