/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.proxy;

public final class ProxyConnectStrategy {
    private final Strategy strategy;
    private final int connectionCount;

    private ProxyConnectStrategy(Strategy strategy, int connectionCount) {
        this.strategy = strategy;
        this.connectionCount = connectionCount;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public String toString() {
        String strategyName = this.strategy.name().toLowerCase();
        switch (this.strategy) {
            case PREPARED: {
                return String.format("%s (%d)", strategyName, this.connectionCount);
            }
        }
        return strategyName;
    }

    public static ProxyConnectStrategy newInstance(Strategy strategy, int connectionCount, int maxConnectionCount) {
        switch (strategy) {
            case PREPARED: {
                if (connectionCount != 0) break;
                connectionCount = maxConnectionCount;
                break;
            }
            case IMMEDIATE: 
            case DEFERRED: {
                if (connectionCount <= 0) break;
                throw new IllegalArgumentException(String.format("Must not prepare connections for connect strategy: %s", new Object[]{strategy}));
            }
            default: {
                throw new IllegalArgumentException(String.format("Unexpected value for connect strategy: %s", new Object[]{strategy}));
            }
        }
        return new ProxyConnectStrategy(strategy, connectionCount);
    }

    static enum Strategy {
        PREPARED,
        IMMEDIATE,
        DEFERRED;

    }
}

