/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.proxy;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;

public final class DeferredConnectStrategyFilter
extends IoFilterAdapter {
    private final AtomicReference<State> sessionOpened = new AtomicReference<State>(State.READY);

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.sessionOpened.compareAndSet(State.READY, State.OBSERVED);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        this.flushSessionOpenedIfNecessary(nextFilter, session);
        super.messageReceived(nextFilter, session, message);
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        this.flushSessionOpenedIfNecessary(nextFilter, session);
        super.messageSent(nextFilter, session, writeRequest);
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        this.flushSessionOpenedIfNecessary(nextFilter, session);
        super.sessionIdle(nextFilter, session, status);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.flushSessionOpenedIfNecessary(nextFilter, session);
        super.sessionClosed(nextFilter, session);
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        this.flushSessionOpenedIfNecessary(nextFilter, session);
        super.exceptionCaught(nextFilter, session, cause);
    }

    private void flushSessionOpenedIfNecessary(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (this.sessionOpened.compareAndSet(State.OBSERVED, State.FLUSHED)) {
            super.sessionOpened(nextFilter, session);
            session.getFilterChain().remove((IoFilter)this);
        }
    }

    private static enum State {
        READY,
        OBSERVED,
        FLUSHED;

    }
}

