/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.proxy;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.proxy.AbstractProxyHandler;
import org.kaazing.gateway.service.proxy.ServiceConnectManager;

class ConnectionPool {
    private static final AttributeKey CONNECT_FUTURE_KEY = new AttributeKey(ServiceConnectManager.class, "connectFutureKey");
    private final ServiceContext serviceContext;
    private final AbstractProxyHandler connectHandler;
    private final URI connectURI;
    private final ServiceConnectManager.HeartbeatFilter heartbeatFilter;
    private final IoFutureListener<ConnectFuture> connectListener;
    private final int preparedConnectionCount;
    private final AtomicInteger currentPreparedConnectionCount;
    private final PreConnectFilter preConnectFilter;
    private final AtomicBoolean preConnectFlag;
    private final ConnectFutures connectFutures;
    private boolean active = false;

    ConnectionPool(ServiceContext serviceContext, AbstractProxyHandler connectHandler, URI connectURI, ServiceConnectManager.HeartbeatFilter heartbeatFilter, IoFutureListener<ConnectFuture> connectListener, int preparedConnectionCount, boolean isThreadAligned) {
        this.serviceContext = serviceContext;
        this.connectHandler = connectHandler;
        this.connectURI = connectURI;
        this.heartbeatFilter = heartbeatFilter;
        this.connectListener = connectListener;
        this.preparedConnectionCount = preparedConnectionCount;
        this.preConnectFlag = new AtomicBoolean(false);
        this.currentPreparedConnectionCount = new AtomicInteger(0);
        this.preConnectFilter = new PreConnectFilter(this);
        this.connectFutures = ConnectFutures.createConnectFutures(preparedConnectionCount, isThreadAligned);
    }

    void start() {
        this.resume();
        if (this.preparedConnectionCount > 0) {
            this.fillPreConnects();
        }
    }

    ConnectFuture getNextConnectFuture(IoSessionInitializer<ConnectFuture> connectInitializer) {
        ConnectFuture future = this.connectFutures.pollFirstEntry();
        if (future == null) {
            future = this.doConnect(false, connectInitializer);
        } else {
            this.currentPreparedConnectionCount.decrementAndGet();
            IoSession connectSession = future.getSession();
            IoFilterChain filterChain = connectSession.getFilterChain();
            if (filterChain.contains("PreConnectFilter")) {
                filterChain.remove("PreConnectFilter");
                connectSession.removeAttribute((Object)CONNECT_FUTURE_KEY);
            }
            if (connectInitializer != null) {
                connectInitializer.initializeSession(connectSession, (IoFuture)future);
            }
        }
        this.fillPreConnects();
        return future;
    }

    private void fillPreConnects() {
        if (this.preConnectFlag.compareAndSet(false, true)) {
            if (this.currentPreparedConnectionCount.get() < this.preparedConnectionCount) {
                do {
                    this.doConnect(true, null);
                } while (this.isActive() && this.currentPreparedConnectionCount.incrementAndGet() < this.preparedConnectionCount);
            }
            this.preConnectFlag.compareAndSet(true, false);
        }
    }

    private boolean isActive() {
        return this.active;
    }

    private void quiesce() {
        this.active = false;
    }

    private void resume() {
        this.active = true;
    }

    void remove(Object key) {
        ConnectFuture future;
        if (key != null && (future = this.connectFutures.remove(key)) != null) {
            this.currentPreparedConnectionCount.decrementAndGet();
        }
    }

    private void decrementConnectionCount() {
        this.currentPreparedConnectionCount.decrementAndGet();
    }

    private void addConnectFuture(ConnectFuture future) {
        Object key = this.connectFutures.add(future);
        future.getSession().setAttributeIfAbsent((Object)CONNECT_FUTURE_KEY, key);
    }

    private ConnectFuture doConnect(final boolean preconnected, final IoSessionInitializer<ConnectFuture> connectInitializer) {
        ConnectFuture future = this.serviceContext.connect(this.connectURI, (IoHandler)this.connectHandler, (IoSessionInitializer)new IoSessionInitializer<ConnectFuture>(){

            public void initializeSession(IoSession connectSession, ConnectFuture future) {
                if (ConnectionPool.this.heartbeatFilter != null) {
                    connectSession.getFilterChain().addLast("ServiceHeartbeat", (IoFilter)ConnectionPool.this.heartbeatFilter);
                }
                connectSession.getFilterChain().addLast("PreConnectFilter", (IoFilter)ConnectionPool.this.preConnectFilter);
                if (connectInitializer != null) {
                    connectInitializer.initializeSession(connectSession, (IoFuture)future);
                }
            }
        });
        future.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture future) {
                if (future.isConnected()) {
                    if (preconnected) {
                        ConnectionPool.this.addConnectFuture(future);
                    }
                } else if (preconnected) {
                    ConnectionPool.this.quiesce();
                    ConnectionPool.this.decrementConnectionCount();
                }
                ConnectionPool.this.connectListener.operationComplete((IoFuture)future);
            }
        });
        return future;
    }

    private static class ArrayWrapConnectFutures
    extends ConnectFutures {
        private final ConnectFuture[] futures;
        private int firstIndex = 0;
        private int insertIndex = -1;

        private ArrayWrapConnectFutures(int maxConnections) {
            this.futures = new ConnectFuture[maxConnections];
        }

        @Override
        Integer add(ConnectFuture future) {
            int n = this.insertIndex = ++this.insertIndex < this.futures.length ? this.insertIndex : 0;
            assert (this.futures[this.insertIndex] == null) : "preparing too many connections";
            this.futures[this.insertIndex] = future;
            if (this.futures[this.firstIndex] == null) {
                this.firstIndex = this.insertIndex;
            }
            return this.insertIndex;
        }

        @Override
        ConnectFuture pollFirstEntry() {
            ConnectFuture result = this.futures[this.firstIndex];
            this.futures[this.firstIndex] = null;
            this.adjustFirstIndex();
            return result;
        }

        @Override
        ConnectFuture remove(Object key) {
            int index = (Integer)key;
            ConnectFuture removed = this.futures[index];
            this.futures[index] = null;
            this.adjustFirstIndex();
            return removed;
        }

        private void adjustFirstIndex() {
            for (int i = 0; this.futures[this.firstIndex] == null && i < this.futures.length; ++i) {
                this.firstIndex = ++this.firstIndex < this.futures.length ? this.firstIndex : 0;
            }
        }
    }

    private static class ThreadSafeConnectFutures
    extends ConnectFutures {
        private final ConcurrentSkipListMap<Long, ConnectFuture> connectFutures;
        AtomicLong nextFutureId = new AtomicLong(0L);

        private ThreadSafeConnectFutures(int preparedConnectionCount) {
            this.connectFutures = new ConcurrentSkipListMap();
        }

        @Override
        ConnectFuture pollFirstEntry() {
            Map.Entry<Long, ConnectFuture> entry = this.connectFutures.pollFirstEntry();
            return entry == null ? null : entry.getValue();
        }

        @Override
        ConnectFuture remove(Object key) {
            return this.connectFutures.remove(key);
        }

        @Override
        Object add(ConnectFuture future) {
            Long key = this.nextFutureId.getAndIncrement();
            this.connectFutures.put(key, future);
            return key;
        }
    }

    private static abstract class ConnectFutures {
        private static final ConnectFutures EMPTY_CONNECT_FUTURES = new ConnectFutures(){

            @Override
            Object add(ConnectFuture future) {
                return null;
            }

            @Override
            ConnectFuture pollFirstEntry() {
                return null;
            }

            @Override
            ConnectFuture remove(Object key) {
                return null;
            }
        };

        private ConnectFutures() {
        }

        abstract Object add(ConnectFuture var1);

        abstract ConnectFuture pollFirstEntry();

        abstract ConnectFuture remove(Object var1);

        private static ConnectFutures createConnectFutures(int preparedConnectionCount, boolean isThreadAligned) {
            return preparedConnectionCount == 0 ? EMPTY_CONNECT_FUTURES : (!isThreadAligned ? new ThreadSafeConnectFutures(preparedConnectionCount) : new ArrayWrapConnectFutures(preparedConnectionCount));
        }
    }

    static class PreConnectFilter
    extends IoFilterAdapter {
        private final ConnectionPool connectManager;

        private PreConnectFilter(ConnectionPool connectManager) {
            this.connectManager = connectManager;
        }

        public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
            this.connectManager.remove(session.getAttribute((Object)CONNECT_FUTURE_KEY));
            super.sessionClosed(nextFilter, session);
        }
    }
}

