/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.proxy;

import java.util.ArrayList;
import java.util.List;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.kaazing.gateway.service.proxy.AbstractProxyAcceptHandler;
import org.kaazing.gateway.service.proxy.AbstractProxyHandler;
import org.kaazing.gateway.service.proxy.ProxyServiceExtensionSpi;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.http.HttpAcceptor;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServiceHandler
extends AbstractProxyAcceptHandler {
    private final Logger logger = LoggerFactory.getLogger(ProxyServiceHandler.class);
    private final List<ProxyServiceExtensionSpi> extensions = new ArrayList<ProxyServiceExtensionSpi>();

    void registerExtension(ProxyServiceExtensionSpi extension) {
        assert (extension != null);
        this.extensions.add(extension);
    }

    @Override
    public void sessionCreated(IoSession serverSession) {
        super.sessionCreated(serverSession);
    }

    @Override
    public void sessionClosed(IoSession serverSession) {
        super.sessionClosed(serverSession);
    }

    @Override
    public void sessionOpened(final IoSession acceptSession) {
        if (!acceptSession.isClosing()) {
            String nextProtocol;
            final Object serviceRegistration = acceptSession.getAttribute((Object)HttpAcceptor.SERVICE_REGISTRATION_KEY);
            ConnectFuture future = this.getNextConnectFuture(new IoSessionInitializer<ConnectFuture>(nextProtocol = (String)BridgeSession.NEXT_PROTOCOL_KEY.get(acceptSession)){
                final /* synthetic */ String val$nextProtocol;
                {
                    this.val$nextProtocol = string;
                }

                public void initializeSession(IoSession connectSession, ConnectFuture future) {
                    if (acceptSession.isClosing()) {
                        connectSession.close(true);
                    } else {
                        connectSession.setAttribute((Object)HttpAcceptor.SERVICE_REGISTRATION_KEY, serviceRegistration);
                        BridgeSession.NEXT_PROTOCOL_KEY.set(connectSession, (Object)this.val$nextProtocol);
                        ProxyServiceHandler.this.initFilterChain(connectSession, true);
                    }
                }
            });
            if (future == null) {
                acceptSession.close(false);
            } else {
                future.addListener((IoFutureListener)new ConnectListener(acceptSession));
            }
            super.sessionOpened(acceptSession);
        }
    }

    @Override
    protected AbstractProxyHandler createConnectHandler() {
        return new ConnectHandler();
    }

    private class ConnectHandler
    extends AbstractProxyHandler {
        private ConnectHandler() {
        }
    }

    private class ConnectListener
    implements IoFutureListener<ConnectFuture> {
        private final IoSession acceptSession;

        public ConnectListener(IoSession acceptSession) {
            this.acceptSession = acceptSession;
        }

        public void operationComplete(ConnectFuture future) {
            if (future.isConnected()) {
                IoSession connectedSession = future.getSession();
                if (ProxyServiceHandler.this.logger.isTraceEnabled()) {
                    ProxyServiceHandler.this.logger.trace("Connected to " + ProxyServiceHandler.this.getConnectURIs().iterator().next() + " [" + this.acceptSession + "->" + connectedSession + "]");
                }
                if (this.acceptSession == null || this.acceptSession.isClosing()) {
                    connectedSession.close(true);
                } else {
                    AbstractProxyHandler.AttachedSessionManager attachedSessionManager = ProxyServiceHandler.this.attachSessions(this.acceptSession, connectedSession);
                    ProxyServiceHandler.this.flushQueuedMessages(this.acceptSession, attachedSessionManager);
                    IoSessionEx acceptSessionEx = (IoSessionEx)this.acceptSession;
                    IoSessionEx connectedSessionEx = (IoSessionEx)connectedSession;
                    for (ProxyServiceExtensionSpi extension : ProxyServiceHandler.this.extensions) {
                        extension.proxiedConnectionEstablished(acceptSessionEx, connectedSessionEx);
                    }
                }
            } else {
                ProxyServiceHandler.this.logger.warn("Connection to " + ProxyServiceHandler.this.getConnectURIs().iterator().next() + " failed [" + this.acceptSession + "->]");
                this.acceptSession.close(true);
            }
        }
    }
}

