/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.proxy;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.ServiceProperties;
import org.kaazing.gateway.service.proxy.AbstractProxyAcceptHandler;
import org.kaazing.gateway.service.proxy.AbstractProxyHandler;
import org.kaazing.gateway.transport.IoHandlerAdapter;
import org.kaazing.gateway.transport.http.DefaultHttpSession;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpConnectSession;
import org.kaazing.gateway.transport.http.HttpSession;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpProxyServiceHandler
extends AbstractProxyAcceptHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"service.http.proxy");
    private static final String VIA_HEADER_VALUE = "1.1 kaazing";
    private static final Set KNOWN_SIMPLE_PROPERTIES;
    private static final Set KNOWN_NESTED_PROPERTIES;
    private String connectURI;
    private boolean rewriteCookieDomain;
    private boolean rewriteCookiePath;
    private boolean rewriteLocation;
    private Map<String, String> cookieDomainMap;
    private Map<String, String> cookiePathMap;
    private Map<String, String> locationMap;

    HttpProxyServiceHandler() {
    }

    void init() {
        ServiceContext serviceContext = this.getServiceContext();
        Collection acceptURIs = serviceContext.getAccepts();
        Collection connectURIs = serviceContext.getConnects();
        String acceptURI = (String)acceptURIs.iterator().next();
        this.connectURI = (String)connectURIs.iterator().next();
        this.validateProperties(serviceContext);
        ServiceProperties properties = serviceContext.getProperties();
        this.rewriteCookieDomain = "enabled".equals(properties.get("rewrite-cookie-domain"));
        this.rewriteCookiePath = "enabled".equals(properties.get("rewrite-cookie-path"));
        this.rewriteLocation = !"disabled".equals(properties.get("rewrite-location"));
        this.cookieDomainMap = new HashMap<String, String>();
        if (this.rewriteCookieDomain) {
            List cookieDomainProperties = properties.getNested("cookie-domain-mapping");
            for (ServiceProperties sp : cookieDomainProperties) {
                this.cookieDomainMap.put(sp.get("from"), sp.get("to"));
            }
        }
        this.cookiePathMap = new HashMap<String, String>();
        if (this.rewriteCookiePath) {
            List cookiePathProperties = properties.getNested("cookie-path-mapping");
            for (ServiceProperties sp : cookiePathProperties) {
                this.cookiePathMap.put(sp.get("from"), sp.get("to"));
            }
        }
        this.locationMap = new HashMap<String, String>();
        if (this.rewriteLocation) {
            List locationProperties = properties.getNested("location-mapping");
            for (ServiceProperties sp : locationProperties) {
                this.locationMap.put(sp.get("from"), sp.get("to"));
            }
            this.locationMap.put(this.connectURI.toString(), acceptURI.toString());
        }
    }

    private void validateProperties(ServiceContext serviceContext) {
        ServiceProperties properties = serviceContext.getProperties();
        Iterable simpleProperties = properties.simplePropertyNames();
        Set unknownProperties = StreamSupport.stream(simpleProperties.spliterator(), false).filter(p -> !KNOWN_SIMPLE_PROPERTIES.contains(p)).collect(Collectors.toSet());
        Iterable nestedProperties = properties.nestedPropertyNames();
        StreamSupport.stream(nestedProperties.spliterator(), false).filter(p -> !KNOWN_NESTED_PROPERTIES.contains(p)).forEach(unknownProperties::add);
        if (!unknownProperties.isEmpty()) {
            throw new IllegalArgumentException(serviceContext.getServiceName() + " http.proxy service specifies unknown properties : " + unknownProperties);
        }
    }

    protected AbstractProxyHandler createConnectHandler() {
        return new ConnectHandler();
    }

    public void sessionOpened(IoSession session) {
        if (!session.isClosing()) {
            DefaultHttpSession acceptSession = (DefaultHttpSession)session;
            if (!this.validateRequestPath(acceptSession)) {
                acceptSession.setStatus(HttpStatus.CLIENT_NOT_FOUND);
                acceptSession.close(false);
                return;
            }
            ConnectSessionInitializer sessionInitializer = new ConnectSessionInitializer(acceptSession);
            ConnectFuture future = this.getServiceContext().connect(this.connectURI, (IoHandler)this.getConnectHandler(), (IoSessionInitializer)sessionInitializer);
            future.addListener((IoFutureListener)new ConnectListener(acceptSession));
            super.sessionOpened((IoSession)acceptSession);
        }
    }

    private boolean validateRequestPath(DefaultHttpSession acceptSession) {
        URI requestURI = acceptSession.getRequestURI();
        String acceptPath = acceptSession.getServicePath().getPath();
        String requestPath = requestURI.normalize().getPath();
        return requestPath.startsWith(acceptPath);
    }

    private static boolean processHopByHopHeaders(HttpSession src, HttpSession dest) {
        boolean upgrade;
        Set<String> hopByHopHeaders = HttpProxyServiceHandler.getHopByHopHeaders(src);
        boolean bl = upgrade = src.getReadHeader("Upgrade") != null;
        if (upgrade) {
            hopByHopHeaders.remove("Upgrade");
        }
        for (Map.Entry e : src.getReadHeaders().entrySet()) {
            String name = (String)e.getKey();
            for (String value : (List)e.getValue()) {
                if (hopByHopHeaders.contains(name)) continue;
                dest.addWriteHeader(name, value);
            }
        }
        return upgrade;
    }

    private static void processRequestHeaders(HttpAcceptSession acceptSession, HttpConnectSession connectSession) {
        boolean upgrade = HttpProxyServiceHandler.processHopByHopHeaders((HttpSession)acceptSession, (HttpSession)connectSession);
        if (upgrade) {
            connectSession.setWriteHeader("Connection", "Upgrade");
        } else {
            ResourceAddress address = connectSession.getRemoteAddress();
            if (!((Boolean)address.getOption(HttpResourceAddress.KEEP_ALIVE)).booleanValue()) {
                connectSession.setWriteHeader("Connection", "close");
            }
        }
        connectSession.addWriteHeader("Via", VIA_HEADER_VALUE);
    }

    private static Set<String> getHopByHopHeaders(HttpSession session) {
        List<String> connectionHeaders = session.getReadHeaders("Connection");
        if (connectionHeaders == null) {
            connectionHeaders = Collections.emptyList();
        }
        TreeSet<String> hopByHopHeaders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String conHeader : connectionHeaders) {
            hopByHopHeaders.add(conHeader);
        }
        hopByHopHeaders.add("Connection");
        return hopByHopHeaders;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("rewrite-cookie-domain");
        set.add("rewrite-cookie-path");
        set.add("rewrite-location");
        KNOWN_SIMPLE_PROPERTIES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("cookie-domain-mapping");
        set.add("cookie-path-mapping");
        set.add("location-mapping");
        KNOWN_NESTED_PROPERTIES = Collections.unmodifiableSet(set);
    }

    private static class Upgrader
    implements IoFutureListener<CloseFuture> {
        private final DefaultHttpSession session;
        private final DefaultHttpSession attachedSession;

        Upgrader(DefaultHttpSession session, DefaultHttpSession attachedSession) {
            this.session = session;
            this.attachedSession = attachedSession;
        }

        public void operationComplete(CloseFuture future) {
            if (this.session.getStatus() == HttpStatus.INFO_SWITCHING_PROTOCOLS) {
                ProxyUpgradeHandler handler = new ProxyUpgradeHandler((IoSession)this.attachedSession.getParent());
                this.session.suspendRead();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("http.proxy service is upgrading session %s", this.session));
                }
                this.session.upgrade((IoHandler)handler);
            }
        }
    }

    private static class ProxyUpgradeHandler
    extends IoHandlerAdapter<IoSessionEx> {
        final IoSession attachedSession;

        ProxyUpgradeHandler(IoSession attachedSession) {
            this.attachedSession = attachedSession;
        }

        protected void doSessionOpened(IoSessionEx session) throws Exception {
            session.resumeRead();
        }

        protected void doMessageReceived(IoSessionEx session, Object message) throws Exception {
            this.attachedSession.write(message);
        }

        protected void doExceptionCaught(IoSessionEx session, Throwable cause) throws Exception {
            this.attachedSession.close(false);
        }

        protected void doSessionClosed(IoSessionEx session) throws Exception {
            this.attachedSession.close(false);
        }
    }

    private class ConnectHandler
    extends AbstractProxyHandler {
        private ConnectHandler() {
        }

        public void messageReceived(IoSession session, Object message) {
            this.processResponseHeaders(session);
            super.messageReceived(session, message);
        }

        public void sessionClosed(IoSession session) {
            this.processResponseHeaders(session);
            super.sessionClosed(session);
        }

        private void processResponseHeaders(IoSession session) {
            HttpAcceptSession acceptSession;
            HttpConnectSession connectSession = (HttpConnectSession)session;
            AbstractProxyHandler.AttachedSessionManager attachedSessionManager = ConnectHandler.getAttachedSessionManager((IoSession)session);
            if (attachedSessionManager != null && (acceptSession = (HttpAcceptSession)attachedSessionManager.getAttachedSession()).getWrittenBytes() == 0L && !acceptSession.isCommitting() && !acceptSession.isClosing()) {
                acceptSession.setStatus(connectSession.getStatus());
                acceptSession.setReason(connectSession.getReason());
                acceptSession.setVersion(connectSession.getVersion());
                this.processResponseHeaders((HttpSession)connectSession, (HttpSession)acceptSession);
            }
        }

        private void processResponseHeaders(HttpSession connectSession, HttpSession acceptSession) {
            boolean upgrade;
            Set hopByHopHeaders = HttpProxyServiceHandler.getHopByHopHeaders(connectSession);
            boolean bl = upgrade = connectSession.getReadHeader("Upgrade") != null;
            if (upgrade) {
                hopByHopHeaders.remove("Upgrade");
            }
            for (Map.Entry e : connectSession.getReadHeaders().entrySet()) {
                String name = (String)e.getKey();
                if (hopByHopHeaders.contains(name)) continue;
                for (String value : (List)e.getValue()) {
                    if (name.equalsIgnoreCase("Set-Cookie")) {
                        if (HttpProxyServiceHandler.this.rewriteCookieDomain) {
                            value = this.processCookieDomain(value, HttpProxyServiceHandler.this.cookieDomainMap);
                        }
                        if (HttpProxyServiceHandler.this.rewriteCookiePath) {
                            value = this.processCookiePath(value, HttpProxyServiceHandler.this.cookiePathMap);
                        }
                        acceptSession.addWriteHeader(name, value);
                        continue;
                    }
                    if (name.equalsIgnoreCase("Location")) {
                        if (HttpProxyServiceHandler.this.rewriteLocation) {
                            value = this.processLocationHeader(value, HttpProxyServiceHandler.this.locationMap);
                        }
                        acceptSession.addWriteHeader(name, value);
                        continue;
                    }
                    acceptSession.addWriteHeader(name, value);
                }
            }
            if (upgrade) {
                acceptSession.setWriteHeader("Connection", "Upgrade");
            }
        }

        private String processCookieDomain(String cookie, Map<String, String> cookieDomainMap) {
            String lowerCookie = cookie.toLowerCase();
            if (lowerCookie.contains("domain=")) {
                return cookieDomainMap.entrySet().stream().filter(e -> lowerCookie.contains("domain=" + (String)e.getKey())).findFirst().map(e -> {
                    int index = lowerCookie.indexOf("domain=" + (String)e.getKey());
                    return cookie.substring(0, index + 7) + (String)e.getValue() + cookie.substring(index + 7 + ((String)e.getKey()).length());
                }).orElse(cookie);
            }
            return cookie;
        }

        private String processCookiePath(String cookie, Map<String, String> cookiePathMap) {
            String lowerCookie = cookie.toLowerCase();
            if (lowerCookie.contains("path=")) {
                return cookiePathMap.entrySet().stream().filter(e -> lowerCookie.contains("path=" + (String)e.getKey())).findFirst().map(e -> {
                    int index = lowerCookie.indexOf("path=" + (String)e.getKey());
                    return cookie.substring(0, index + 5) + (String)e.getValue() + cookie.substring(index + 5 + ((String)e.getKey()).length());
                }).orElse(cookie);
            }
            return cookie;
        }

        private String processLocationHeader(String location, Map<String, String> locationMap) {
            return locationMap.entrySet().stream().filter(e -> location.startsWith((String)e.getKey())).findFirst().map(e -> location.replaceFirst(Pattern.quote((String)e.getKey()), (String)e.getValue())).orElse(location);
        }
    }

    private class ConnectListener
    implements IoFutureListener<ConnectFuture> {
        private final DefaultHttpSession acceptSession;

        ConnectListener(DefaultHttpSession acceptSession) {
            this.acceptSession = acceptSession;
        }

        public void operationComplete(ConnectFuture future) {
            if (future.isConnected()) {
                DefaultHttpSession connectSession = (DefaultHttpSession)future.getSession();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Connected to " + (String)HttpProxyServiceHandler.this.getConnectURIs().iterator().next() + " [" + this.acceptSession + "->" + connectSession + "]");
                }
                if (this.acceptSession == null || this.acceptSession.isClosing()) {
                    connectSession.close(true);
                } else {
                    AbstractProxyHandler.AttachedSessionManager attachedSessionManager = HttpProxyServiceHandler.this.attachSessions((IoSession)this.acceptSession, (IoSession)connectSession);
                    connectSession.getCloseFuture().addListener((IoFutureListener)new Upgrader(connectSession, this.acceptSession));
                    this.acceptSession.getCloseFuture().addListener((IoFutureListener)new Upgrader(this.acceptSession, connectSession));
                    HttpProxyServiceHandler.this.flushQueuedMessages((IoSession)this.acceptSession, attachedSessionManager);
                }
            } else {
                LOGGER.warn("Connection to " + (String)HttpProxyServiceHandler.this.getConnectURIs().iterator().next() + " failed [" + this.acceptSession + "->]");
                this.acceptSession.setStatus(HttpStatus.SERVER_GATEWAY_TIMEOUT);
                this.acceptSession.close(true);
            }
        }
    }

    private static class ConnectSessionInitializer
    implements IoSessionInitializer<ConnectFuture> {
        private final DefaultHttpSession acceptSession;

        ConnectSessionInitializer(DefaultHttpSession acceptSession) {
            this.acceptSession = acceptSession;
        }

        public void initializeSession(IoSession session, ConnectFuture future) {
            HttpConnectSession connectSession = (HttpConnectSession)session;
            connectSession.setVersion(this.acceptSession.getVersion());
            connectSession.setMethod(this.acceptSession.getMethod());
            URI connectURI = this.computeConnectPath(connectSession.getRequestURI());
            connectSession.setRequestURI(connectURI);
            HttpProxyServiceHandler.processRequestHeaders((HttpAcceptSession)this.acceptSession, connectSession);
        }

        private URI computeConnectPath(URI connectURI) {
            String acceptPath = this.acceptSession.getServicePath().getPath();
            String requestUri = this.acceptSession.getRequestURI().toString();
            String connectPath = connectURI.getPath();
            return URI.create(connectPath + requestUri.substring(acceptPath.length()));
        }
    }
}

