/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.directory.cachecontrol;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.kaazing.gateway.service.http.directory.cachecontrol.Directive;
import org.kaazing.gateway.service.http.directory.cachecontrol.PatternCacheControl;

public class CacheControlHandler {
    private static final String DIRECTIVES_SEPARATOR = ", ";
    private static final String EQUALS_STRING = "=";
    private static final String EMPTY_STRING_VALUE = "";
    private File requestFile;
    private StringBuilder staticDirectives = new StringBuilder();
    private Map<Directive, String> maxAgeDirectives = new HashMap<Directive, String>();
    private boolean isMaxAgeResolved;
    private long maxAgeResolvedValue;

    public CacheControlHandler(File requestedFile, PatternCacheControl patternCacheControl) {
        this.requestFile = requestedFile;
        this.buildDirectives(patternCacheControl);
    }

    public File getRequestFile() {
        return this.requestFile;
    }

    public String getCacheControlHeader() {
        this.checkIfMaxAgeIsResolved();
        String maxAge = Directive.MAX_AGE.getName() + EQUALS_STRING + (this.maxAgeResolvedValue > 0L ? Long.valueOf(this.maxAgeResolvedValue) : "0");
        return this.staticDirectives.toString() + maxAge;
    }

    public long getExpiresHeader() {
        this.checkIfMaxAgeIsResolved();
        long currentTimeMillis = System.currentTimeMillis();
        return this.maxAgeResolvedValue * 1000L + currentTimeMillis;
    }

    public void resetState() {
        this.isMaxAgeResolved = false;
        this.maxAgeResolvedValue = 0L;
    }

    private void checkIfMaxAgeIsResolved() {
        if (!this.isMaxAgeResolved) {
            this.resolveMaxAgeConflicts();
        }
    }

    private void resolveMaxAgeConflicts() {
        long lastModified = this.requestFile.lastModified();
        String maxAgeString = EMPTY_STRING_VALUE;
        String maxAge = this.maxAgeDirectives.get((Object)Directive.MAX_AGE);
        String maxAgeMPlus = this.maxAgeDirectives.get((Object)Directive.MAX_AGE_MPLUS);
        if (maxAgeMPlus != null) {
            String maxAgeMPlusValue = this.parseMaxAgeMplus(maxAgeMPlus, lastModified);
            maxAgeString = maxAge != null ? (Long.parseLong(maxAge) < Long.parseLong(maxAgeMPlusValue) ? maxAge : maxAgeMPlusValue) : maxAgeMPlusValue;
        } else if (maxAge != null) {
            maxAgeString = maxAge;
        }
        this.maxAgeResolvedValue = Long.parseLong(maxAgeString);
        this.isMaxAgeResolved = true;
    }

    private String parseMaxAgeMplus(String value, long lastModified) {
        long currentTimeMillis = System.currentTimeMillis();
        return Long.toString(Long.parseLong(value) + (lastModified - currentTimeMillis) / 1000L);
    }

    private void buildDirectives(PatternCacheControl patternCacheControl) {
        block3: for (Map.Entry<Directive, String> entry : patternCacheControl.getDirectives().entrySet()) {
            Directive key = entry.getKey();
            String value = entry.getValue();
            switch (key) {
                case MAX_AGE: 
                case MAX_AGE_MPLUS: {
                    this.maxAgeDirectives.put(key, value);
                    continue block3;
                }
            }
            if (value.equals(EMPTY_STRING_VALUE)) {
                this.staticDirectives.append(key.getName() + DIRECTIVES_SEPARATOR);
                continue;
            }
            this.staticDirectives.append(key.getName() + EQUALS_STRING + value + DIRECTIVES_SEPARATOR);
        }
    }
}

