/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.directory.cachecontrol;

import java.util.Map;
import org.kaazing.gateway.service.http.directory.cachecontrol.Directive;
import org.kaazing.gateway.service.http.directory.cachecontrol.PatternCacheControl;

public final class ConflictResolverUtils {
    private static final String EMPTY_STRING_VALUE = "";

    private ConflictResolverUtils() {
    }

    public static void resolveConflicts(PatternCacheControl specificPattern, PatternCacheControl generalPattern) {
        for (Map.Entry<Directive, String> entry : generalPattern.getDirectives().entrySet()) {
            Directive generalDirective = entry.getKey();
            String generalValue = entry.getValue();
            if (generalValue == EMPTY_STRING_VALUE) {
                specificPattern.setDirective(generalDirective, EMPTY_STRING_VALUE);
                continue;
            }
            ConflictResolverUtils.resolveValueConflicts(generalDirective, generalValue, specificPattern);
        }
    }

    private static void resolveValueConflicts(Directive directive, String generalValue, PatternCacheControl specificPattern) {
        long generalPatternValue = Long.parseLong(generalValue);
        if (specificPattern.hasDirective(directive)) {
            long specificPatternValue = Long.parseLong(specificPattern.getDirectiveValue(directive));
            if (specificPatternValue > generalPatternValue) {
                specificPattern.setDirective(directive, generalValue);
            }
            return;
        }
        specificPattern.setDirective(directive, generalValue);
    }
}

