/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.echo;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.transport.IoHandlerAdapter;
import org.kaazing.gateway.transport.LoggingUtils;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;

class EchoServiceHandler
extends IoHandlerAdapter<IoSessionEx> {
    private final Logger logger;
    static final int DEFAULT_REPEAT_COUNT = 1;
    private final int repeatCount;

    EchoServiceHandler(int repeatCount, Logger logger) {
        this.repeatCount = repeatCount;
        this.logger = logger;
    }

    protected void doMessageReceived(final IoSessionEx session, Object message) throws Exception {
        if (message instanceof IoBufferEx) {
            final IoBufferEx buf = (IoBufferEx)message;
            int maximumStackDepth = 10;
            final AtomicInteger listenerInvocationCount = new AtomicInteger();
            final AtomicInteger listenerPendingCount = new AtomicInteger(10);
            final AtomicInteger remainingMessages = new AtomicInteger(this.repeatCount);
            IoFutureListener<WriteFuture> listener = new IoFutureListener<WriteFuture>(){

                public void operationComplete(WriteFuture future) {
                    if (listenerInvocationCount.get() < 10) {
                        while (listenerInvocationCount.incrementAndGet() < 10) {
                            if (remainingMessages.decrementAndGet() < 0) continue;
                            session.write((Object)buf).addListener((IoFutureListener)this);
                        }
                    }
                    if (listenerPendingCount.decrementAndGet() <= 0) {
                        listenerInvocationCount.set(0);
                        listenerPendingCount.set(10);
                        if (remainingMessages.decrementAndGet() >= 0) {
                            session.write((Object)buf).addListener((IoFutureListener)this);
                        }
                    }
                }
            };
            if (remainingMessages.decrementAndGet() >= 0) {
                session.write((Object)buf).addListener((IoFutureListener)listener);
            }
        } else {
            for (int i = 0; i < this.repeatCount; ++i) {
                session.write(message);
            }
        }
    }

    protected void doExceptionCaught(IoSessionEx session, Throwable cause) throws Exception {
        LoggingUtils.log((IoSession)session, (Logger)this.logger, (Throwable)cause);
    }
}

