/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.echo;

import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.ServiceProperties;
import org.kaazing.gateway.service.echo.EchoServiceHandler;
import org.kaazing.gateway.service.util.ServiceUtils;

public class EchoService
implements Service {
    private EchoServiceHandler handler;
    private ServiceContext serviceContext;

    public String getType() {
        return "echo";
    }

    public void init(ServiceContext serviceContext) throws Exception {
        this.serviceContext = serviceContext;
        ServiceProperties properties = serviceContext.getProperties();
        int repeatCount = ServiceUtils.getOptionalIntProperty((ServiceProperties)properties, (String)"repeat", (int)1);
        this.handler = new EchoServiceHandler(repeatCount);
    }

    public void start() throws Exception {
        this.serviceContext.bind(this.serviceContext.getAccepts(), (IoHandler)this.handler);
    }

    public void stop() throws Exception {
        this.quiesce();
        if (this.serviceContext != null) {
            for (IoSession session : this.serviceContext.getActiveSessions()) {
                session.close(true);
            }
        }
    }

    public void quiesce() throws Exception {
        if (this.serviceContext != null) {
            this.serviceContext.unbind(this.serviceContext.getAccepts(), (IoHandler)this.handler);
        }
    }

    public void destroy() throws Exception {
    }
}

