/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.util.Utils;
import org.kaazing.gateway.util.ssl.SslCipherSuites;
import org.kaazing.gateway.util.ws.WebSocketWireProtocol;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DefaultOptionsContext {
    private static final int DEFAULT_WEBSOCKET_MAXIMUM_MESSAGE_SIZE = 131072;
    private static final int DEFAULT_HTTP_KEEPALIVE_TIMEOUT = 30;
    private static final long UNLIMITED_MAX_OUTPUT_RATE = 0xFFFFFFFFL;
    private static final long DEFAULT_TCP_MAXIMUM_OUTBOUND_RATE = 0xFFFFFFFFL;
    private static final long DEFAULT_WS_INACTIVITY_TIMEOUT_MILLIS = 0L;

    DefaultOptionsContext() {
    }

    static String resolveInternalBindOptionName(String externalBindOptionName) {
        switch (externalBindOptionName) {
            case "tcp": {
                return "tcp.bind";
            }
            case "ssl": {
                return "ssl.tcp.bind";
            }
            case "http": {
                return "http.tcp.bind";
            }
            case "https": {
                return "http.ssl.tcp.bind";
            }
            case "ws": {
                return "ws.http.tcp.bind";
            }
            case "wss": {
                return "ws.http.ssl.tcp.bind";
            }
            case "wsn": {
                return "wsn.http.tcp.bind";
            }
            case "wsn+ssl": {
                return "wsn.http.ssl.tcp.bind";
            }
            case "wsx": {
                return "wsn.http.wsn.http.tcp.bind";
            }
            case "wsx+ssl": {
                return "wsn.http.wsn.http.ssl.tcp.bind";
            }
            case "httpxe": {
                return "http.http.tcp.bind";
            }
            case "httpxe+ssl": {
                return "http.http.ssl.tcp.bind";
            }
        }
        return null;
    }

    private static String[] resolveProtocols(String csv) {
        if (csv != null && !csv.equals("")) {
            return csv.split(",");
        }
        return null;
    }

    static long getWsInactivityTimeout(String value) {
        long val;
        long wsInactivityTimeout = 0L;
        if (value != null && (val = Utils.parseTimeInterval((String)value, (TimeUnit)TimeUnit.MILLISECONDS)) > 0L) {
            wsInactivityTimeout = val;
        }
        return wsInactivityTimeout;
    }

    static String getTransportURI(String transportKey, String transport) {
        String transportURI = null;
        if (transport != null) {
            transportURI = transport;
            if (!URIUtils.isAbsolute((String)transportURI)) {
                throw new IllegalArgumentException(String.format("%s must contain an absolute URI, not \"%s\"", transportKey, transport));
            }
            transportURI = URIUtils.getCanonicalizedURI((String)transportURI, (boolean)false);
        }
        return transportURI;
    }

    static int getWsMaximumMessageSize(String wsMaxMessageSizeValue) {
        int wsMaxMessageSize = 131072;
        if (wsMaxMessageSizeValue != null) {
            wsMaxMessageSize = Utils.parseDataSize((String)wsMaxMessageSizeValue);
        }
        return wsMaxMessageSize;
    }

    static long getTcpMaximumOutboundRate(String tcpMaxOutboundRate) {
        long tcpMaximumOutboundRate = 0xFFFFFFFFL;
        if (tcpMaxOutboundRate != null && ((tcpMaximumOutboundRate = Utils.parseDataRate((String)tcpMaxOutboundRate)) == 0L || tcpMaximumOutboundRate > 0xFFFFFFFFL)) {
            tcpMaximumOutboundRate = 0xFFFFFFFFL;
        }
        return tcpMaximumOutboundRate;
    }

    static boolean[] getVerifyClientProperties(String sslVerifyClientValue) {
        boolean[] clientAuth = new boolean[]{false, false};
        if (sslVerifyClientValue != null) {
            if (sslVerifyClientValue.equalsIgnoreCase("required")) {
                clientAuth[0] = false;
                clientAuth[1] = true;
            } else if (sslVerifyClientValue.equalsIgnoreCase("optional")) {
                clientAuth[0] = true;
                clientAuth[1] = false;
            }
        }
        return clientAuth;
    }

    static boolean isSslEncryptionEnabled(String sslEncryptionEnabledValue) {
        boolean sslEncryptionEnabled = true;
        if (sslEncryptionEnabledValue != null) {
            sslEncryptionEnabled = !sslEncryptionEnabledValue.equalsIgnoreCase("disabled");
        }
        return sslEncryptionEnabled;
    }

    static boolean isHttpServerHeaderEnabled(String serverHeaderEnabled) {
        return serverHeaderEnabled == null || !serverHeaderEnabled.equalsIgnoreCase("disabled");
    }

    static String[] getSslProtocols(String sslProtocolsValue) {
        String[] sslProtocols = null;
        if (sslProtocolsValue != null) {
            sslProtocols = DefaultOptionsContext.resolveProtocols(sslProtocolsValue);
        }
        return sslProtocols;
    }

    static String[] getSslCiphers(String sslCiphersValue) {
        String[] sslCiphers = null;
        if (sslCiphersValue != null) {
            sslCiphers = SslCipherSuites.resolveCSV((String)sslCiphersValue);
        }
        return sslCiphers;
    }

    static int getHttpKeepaliveTimeout(String httpKeepaliveTimeoutValue) {
        long val;
        int httpKeepaliveTimeout = 30;
        if (httpKeepaliveTimeoutValue != null && (val = Utils.parseTimeInterval((String)httpKeepaliveTimeoutValue, (TimeUnit)TimeUnit.SECONDS)) > 0L) {
            httpKeepaliveTimeout = (int)val;
        }
        return httpKeepaliveTimeout;
    }

    static Integer getHttpKeepaliveConnections(String connectionsValue) {
        Integer maxConnections = null;
        if (connectionsValue != null) {
            int val = Integer.parseInt(connectionsValue);
            if (val > 0) {
                maxConnections = val;
            } else {
                String msg = String.format("http.keepalive.connections = %s must be > 0", connectionsValue);
                throw new IllegalArgumentException(msg);
            }
        }
        return maxConnections;
    }

    static boolean isHttpKeepaliveEnabled(String httpKeepaliveEnabledValue) {
        boolean httpKeepaliveEnabled = true;
        if (httpKeepaliveEnabledValue != null) {
            httpKeepaliveEnabled = !httpKeepaliveEnabledValue.equalsIgnoreCase("disabled");
        }
        return httpKeepaliveEnabled;
    }

    static WebSocketWireProtocol getWebSocketWireProtocol(String wsVersion) {
        WebSocketWireProtocol protocol = WebSocketWireProtocol.RFC_6455;
        if ("draft-75".equals(wsVersion)) {
            protocol = WebSocketWireProtocol.HIXIE_75;
        }
        return protocol;
    }

    static Map<String, String> parseOptions(Node parent) {
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (1 != node.getNodeType()) continue;
            NodeList content = node.getChildNodes();
            String nodeValue = "";
            for (int j = 0; j < content.getLength(); ++j) {
                String fragment;
                Node child = content.item(j);
                if (child == null || child.getNodeType() != 3 || (fragment = child.getNodeValue()) == null) continue;
                nodeValue = nodeValue + fragment;
            }
            String localName = node.getLocalName();
            if (localName.contains("tls")) {
                localName = localName.replace("tls", "ssl");
            }
            if (localName.contains(".transport") && nodeValue.contains("tls://")) {
                nodeValue = nodeValue.replace("tls://", "ssl://");
            }
            optionsMap.put(localName, nodeValue);
        }
        return optionsMap;
    }
}

