/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.collections;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import org.kaazing.gateway.service.collections.CollectionsFactory;
import org.kaazing.gateway.util.AtomicCounter;

public class ClusterCollectionsFactory
implements CollectionsFactory {
    private HazelcastInstance cluster;

    public ClusterCollectionsFactory(HazelcastInstance cluster) {
        this.cluster = cluster;
    }

    public <E> IList<E> getList(String name) {
        return this.cluster.getList(name);
    }

    public <K, V> IMap<K, V> getMap(String name) {
        return this.cluster.getMap(name);
    }

    public <E> IQueue<E> getQueue(String name) {
        return this.cluster.getQueue(name);
    }

    public <E> ITopic<E> getTopic(String name) {
        return this.cluster.getTopic(name);
    }

    public ILock getLock(String name) {
        return this.cluster.getLock(name);
    }

    public AtomicCounter getAtomicCounter(String name) {
        return new ClusterAtomicCounter(this.cluster.getAtomicLong(name));
    }

    private final class ClusterAtomicCounter
    implements AtomicCounter {
        private IAtomicLong atomicNumber;

        private ClusterAtomicCounter(IAtomicLong number) {
            this.atomicNumber = number;
        }

        public long get() {
            return this.atomicNumber.get();
        }

        public long incrementAndGet() {
            return this.atomicNumber.incrementAndGet();
        }

        public long decrementAndGet() {
            return this.atomicNumber.decrementAndGet();
        }

        public boolean compareAndSet(long expect, long update) {
            return this.atomicNumber.compareAndSet(expect, update);
        }
    }
}

