/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.config.parse.translate.nov2015;

import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.kaazing.gateway.server.config.parse.translate.AbstractVisitor;

public class AddDirectoryServiceLocationVisitor
extends AbstractVisitor {
    private static final String PROPERTIES = "properties";
    private static final String DIRECTORY = "directory";
    private static final String TYPE = "type";
    private static final String SERVICE_NODE = "service";
    private static final String LOCATION = "location";
    private static final String PATTERNS = "patterns";
    private static final String CACHE_CONTROL = "cache-control";
    private static final String GENERIC_PATTERN = "**/*";
    private static final String MAX_AGE_VALUE = "max-age=0";
    private Namespace namespace;

    @Override
    public void visit(Element element) throws Exception {
        Element typeElement = element.getChild(TYPE, this.namespace);
        String type = typeElement.getTextTrim();
        if (type.equalsIgnoreCase(DIRECTORY)) {
            Element location = new Element(LOCATION, this.namespace);
            Element patterns = new Element(PATTERNS, this.namespace);
            patterns.setText(GENERIC_PATTERN);
            location.addContent((Content)patterns);
            Element cacheControl = new Element(CACHE_CONTROL, this.namespace);
            cacheControl.setText(MAX_AGE_VALUE);
            location.addContent((Content)cacheControl);
            Element propertiesElement = element.getChild(PROPERTIES, this.namespace);
            propertiesElement.addContent((Content)location);
        }
    }

    @Override
    public void translate(Document dom) throws Exception {
        Element root = dom.getRootElement();
        this.namespace = root.getNamespace();
        List children = dom.getRootElement().getChildren(SERVICE_NODE, this.namespace);
        for (Element child : children) {
            this.visit(child);
        }
    }
}

