/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.kaazing.gateway.server.Gateway;
import org.kaazing.gateway.server.GatewayFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayCommandLineProcessor {
    private static final String CONFIG_ARG = "config";
    private static final String HELP_ARG = "help";
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayCommandLineProcessor.class);
    private HelpFormatter helpFormatter;

    protected GatewayCommandLineProcessor(HelpFormatter helpFormatter) {
        this.helpFormatter = helpFormatter;
    }

    public void launchGateway(String[] args) {
        this.launchGateway(args, System.getProperties());
    }

    private void launchGateway(String[] args, Properties properties) {
        CommandLine cmd = null;
        Options options = this.createOptions();
        try {
            PosixParser parser = new PosixParser();
            cmd = parser.parse(options, args);
        }
        catch (ParseException ex) {
            this.printCliHelp("There was a problem with a command-line argument:\n" + ex.getMessage(), options, cmd);
            return;
        }
        String[] nonProcessedArgs = cmd.getArgs();
        if (nonProcessedArgs != null && nonProcessedArgs.length > 0) {
            System.out.println("There was a problem with the command-line arguments.");
            System.out.println("One or more unknown arguments were not processed:");
            for (String nonProcessedArg : nonProcessedArgs) {
                System.out.println("   " + nonProcessedArg);
            }
            this.printCliHelp(null, options, cmd);
            return;
        }
        if (cmd.hasOption(HELP_ARG)) {
            this.printCliHelp(null, options, cmd);
            return;
        }
        String config = cmd.getOptionValue(CONFIG_ARG);
        if (config != null) {
            properties.setProperty("GATEWAY_CONFIG", config);
        }
        final Gateway gateway = GatewayFactory.createGateway();
        gateway.setProperties(properties);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    gateway.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            gateway.launch();
        }
        catch (Exception ex) {
            LOGGER.error("Gateway failed to launch", (Throwable)ex);
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private void printCliHelp(String message, Options options, CommandLine cmd) {
        if (message != null) {
            System.out.println(message);
        }
        Options all_opt = new Options();
        for (Object o : options.getOptions()) {
            Option o1 = (Option)o;
            all_opt.addOption(o1);
        }
        File helpScript = this.getScriptedOptsFile();
        this.appendScriptedOptions(helpScript, all_opt);
        this.helpFormatter.printHelp("gateway.start", all_opt, true);
    }

    private File getScriptedOptsFile() {
        File helpScript = null;
        String helpScriptPath = System.getenv("SCRIPTED_ARGS");
        if (helpScriptPath != null) {
            helpScript = new File(helpScriptPath);
        }
        return helpScript;
    }

    private void appendScriptedOptions(File helpScript, Options all_opt) {
        try {
            if (helpScript != null && helpScript.exists()) {
                String[] nextLine;
                InputStreamReader input_opt = new InputStreamReader(new FileInputStream(helpScript));
                CSVReader script_options = new CSVReader((Reader)input_opt);
                while ((nextLine = script_options.readNext()) != null) {
                    if (nextLine.length < 3) continue;
                    Option o = new Option(null, nextLine[0], Boolean.parseBoolean(nextLine[1]), nextLine[2]);
                    all_opt.addOption(o);
                }
                script_options.close();
            }
        }
        catch (IOException e) {
            LOGGER.debug("Exception when trying  to get scripted arguments", (Throwable)e);
        }
    }

    private Options createOptions() {
        Options options = new Options();
        options.addOption(null, CONFIG_ARG, true, "path to gateway configuration file");
        options.addOption(null, HELP_ARG, false, "print the help text");
        return options;
    }
}

