/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.server.config.june2016.ServiceAcceptOptionsType;
import org.kaazing.gateway.server.context.resolve.DefaultOptionsContext;
import org.kaazing.gateway.service.AcceptOptionsContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAcceptOptionsContext
extends DefaultOptionsContext
implements AcceptOptionsContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAcceptOptionsContext.class);
    private static final String EXTENDED_HANDSHAKE_PROTOCOL_NAME = "x-kaazing-handshake";
    private static final List<String> DEFAULT_WEBSOCKET_PROTOCOLS = Arrays.asList("x-kaazing-handshake", null);
    private final Map<String, String> binds;
    private final Map<String, String> options;

    public DefaultAcceptOptionsContext() {
        this.binds = new HashMap<String, String>();
        this.options = Collections.emptyMap();
    }

    public DefaultAcceptOptionsContext(ServiceAcceptOptionsType acceptOptions, ServiceAcceptOptionsType defaultOptions) {
        Map<String, String> options = this.parseAcceptOptionsType(acceptOptions);
        this.parseAcceptOptionsType(defaultOptions).entrySet().stream().forEach(e -> {
            String cfr_ignored_0 = (String)options.putIfAbsent((String)e.getKey(), (String)e.getValue());
        });
        this.binds = new HashMap<String, String>();
        this.addBind("ws", options.remove("ws.bind"));
        this.addBind("wss", options.remove("wss.bind"));
        this.addBind("http", options.remove("http.bind"));
        this.addBind("https", options.remove("https.bind"));
        this.addBind("ssl", options.remove("ssl.bind"));
        this.addBind("tcp", options.remove("tcp.bind"));
        this.options = Collections.unmodifiableMap(options);
    }

    public Map<String, String> getBinds() {
        return this.binds;
    }

    public String getInternalURI(String externalURI) {
        String authority = URIUtils.getAuthority((String)externalURI);
        String internalAuthority = this.binds.get(URIUtils.getScheme((String)externalURI));
        if (internalAuthority != null) {
            if (!internalAuthority.equals(authority)) {
                try {
                    return URIUtils.buildURIAsString((String)URIUtils.getScheme((String)externalURI), (String)internalAuthority, (String)URIUtils.getPath((String)externalURI), (String)URIUtils.getQuery((String)externalURI), (String)URIUtils.getFragment((String)externalURI));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return externalURI;
        }
        return null;
    }

    public void addBind(String scheme, String hostPort) {
        if (hostPort != null && !this.binds.containsKey(scheme)) {
            if (!hostPort.contains(":")) {
                try {
                    int port = Integer.parseInt(hostPort);
                    this.binds.put(scheme, "0.0.0.0:" + port);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("Failed to add bind for scheme " + scheme + " to port " + hostPort, ex);
                }
            } else {
                this.binds.put(scheme, hostPort);
            }
        }
    }

    public Map<String, Object> asOptionsMap() {
        String httpTransport;
        String sslTransport;
        String tcpTransport;
        String[] sslProtocols;
        String[] sslCiphers;
        HashMap<String, String> optionsCopy = new HashMap<String, String>(this.options);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("supportedProtocols", DEFAULT_WEBSOCKET_PROTOCOLS.toArray(new String[DEFAULT_WEBSOCKET_PROTOCOLS.size()]));
        String wsInactivityTimeoutStr = (String)optionsCopy.remove("ws.inactivity.timeout");
        String httpKeepaliveTimeoutStr = (String)optionsCopy.remove("http.keepalive.timeout");
        if (wsInactivityTimeoutStr != null && httpKeepaliveTimeoutStr == null) {
            httpKeepaliveTimeoutStr = wsInactivityTimeoutStr;
        }
        long wsInactivityTimeout = DefaultAcceptOptionsContext.getWsInactivityTimeout(wsInactivityTimeoutStr);
        result.put("ws.inactivityTimeout", wsInactivityTimeout);
        result.put("ws[ws/rfc6455].ws[ws/rfc6455].inactivityTimeout", wsInactivityTimeout);
        result.put("ws[ws/draft-7x].ws[ws/draft-7x].inactivityTimeout", wsInactivityTimeout);
        int wsMaxMessageSize = DefaultAcceptOptionsContext.getWsMaximumMessageSize((String)optionsCopy.remove("ws.maximum.message.size"));
        result.put("ws.maxMessageSize", wsMaxMessageSize);
        result.put("ws[ws/rfc6455].ws[ws/rfc6455].maxMessageSize", wsMaxMessageSize);
        result.put("ws[ws/draft-7x].ws[ws/draft-7x].maxMessageSize", wsMaxMessageSize);
        int httpKeepaliveTimeout = DefaultAcceptOptionsContext.getHttpKeepaliveTimeout(httpKeepaliveTimeoutStr);
        result.put("http[http/1.1].keepAliveTimeout", httpKeepaliveTimeout);
        if (wsInactivityTimeoutStr != null && TimeUnit.MILLISECONDS.convert(httpKeepaliveTimeout, TimeUnit.SECONDS) < wsInactivityTimeout) {
            LOGGER.warn("http.keealive.timeout={} should be greater than ws.inactivity.timeout={}", (Object)wsInactivityTimeoutStr, (Object)httpKeepaliveTimeoutStr);
        }
        if ((sslCiphers = DefaultAcceptOptionsContext.getSslCiphers((String)optionsCopy.remove("ssl.ciphers"))) != null) {
            result.put("ssl.ciphers", sslCiphers);
        }
        if ((sslProtocols = DefaultAcceptOptionsContext.getSslProtocols((String)optionsCopy.remove("ssl.protocols"))) != null) {
            result.put("ssl.protocols", sslProtocols);
        }
        boolean sslEncryptionEnabled = DefaultAcceptOptionsContext.isSslEncryptionEnabled((String)optionsCopy.remove("ssl.encryption"));
        result.put("ssl.encryptionEnabled", sslEncryptionEnabled);
        boolean serverHeaderEnabled = DefaultAcceptOptionsContext.isHttpServerHeaderEnabled((String)optionsCopy.remove("http.server.header"));
        result.put("http.serverHeaderEnabled", serverHeaderEnabled);
        String sslVerifyClientValue = (String)optionsCopy.remove("ssl.verify-client");
        boolean[] clientAuth = DefaultAcceptOptionsContext.getVerifyClientProperties(sslVerifyClientValue);
        result.put("ssl.wantClientAuth", clientAuth[0]);
        result.put("ssl.needClientAuth", clientAuth[1]);
        String pipeTransport = DefaultAcceptOptionsContext.getTransportURI("pipe.transport", (String)optionsCopy.remove("pipe.transport"));
        if (pipeTransport != null) {
            result.put("pipe.transport", pipeTransport);
        }
        if ((tcpTransport = DefaultAcceptOptionsContext.getTransportURI("tcp.transport", (String)optionsCopy.remove("tcp.transport"))) != null) {
            result.put("tcp.transport", tcpTransport);
        }
        if ((sslTransport = DefaultAcceptOptionsContext.getTransportURI("ssl.transport", (String)optionsCopy.remove("ssl.transport"))) != null) {
            result.put("ssl.transport", sslTransport);
        }
        if ((httpTransport = DefaultAcceptOptionsContext.getTransportURI("http.transport", (String)optionsCopy.remove("http.transport"))) != null) {
            result.put("http[http/1.1].transport", httpTransport);
        }
        long tcpMaximumOutboundRate = DefaultAcceptOptionsContext.getTcpMaximumOutboundRate((String)optionsCopy.remove("tcp.maximum.outbound.rate"));
        result.put("tcp.maximumOutboundRate", tcpMaximumOutboundRate);
        for (Map.Entry<String, String> entry : this.getBinds().entrySet()) {
            String internalBindOptionName = DefaultAcceptOptionsContext.resolveInternalBindOptionName(entry.getKey());
            if (internalBindOptionName != null) {
                result.put(internalBindOptionName, entry.getValue());
                continue;
            }
            throw new RuntimeException("Cannot apply unknown bind option '" + entry.getKey() + "'.");
        }
        result.putAll(optionsCopy);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Accept options map = %s", result));
        }
        return result;
    }

    private Map<String, String> parseAcceptOptionsType(ServiceAcceptOptionsType acceptOptionsType) {
        return acceptOptionsType != null ? DefaultAcceptOptionsContext.parseOptions(acceptOptionsType.getDomNode()) : new HashMap();
    }
}

