/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSessionInitializer;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.server.Launcher;
import org.kaazing.gateway.server.context.TransportContext;
import org.kaazing.gateway.transport.BridgeAcceptor;
import org.kaazing.gateway.transport.BridgeConnector;
import org.kaazing.gateway.transport.BridgeSessionInitializer;
import org.kaazing.gateway.transport.Transport;
import org.slf4j.Logger;

public class DefaultTransportContext
implements TransportContext<ResourceAddress> {
    private final String name;
    private final BridgeAcceptor acceptor;
    private final BridgeConnector connector;
    private final Transport transport;
    private static final Logger LOGGER = Launcher.getGatewayStartupLogger();

    public DefaultTransportContext(String name, Transport transport) {
        this.name = name;
        this.transport = transport;
        this.acceptor = transport.getAcceptor();
        this.connector = transport.getConnector();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void bind(ResourceAddress address, IoHandler handler, BridgeSessionInitializer<?> initializer) {
        if (this.acceptor != null) {
            try {
                this.acceptor.bind(address, handler, initializer);
            }
            catch (RuntimeException re) {
                throw new RuntimeException(String.format("Error binding to %s: %s", address.getResource(), re.getMessage()), re);
            }
        }
    }

    @Override
    public final void unbind(ResourceAddress address) {
        if (this.acceptor != null) {
            this.acceptor.unbind(address).awaitUninterruptibly();
        }
    }

    @Override
    public void connectInit(ResourceAddress address) {
        if (this.connector != null) {
            this.connector.connectInit(address);
        }
    }

    @Override
    public ConnectFuture connect(ResourceAddress address, IoHandler handler, IoSessionInitializer<? extends ConnectFuture> initializer) {
        if (this.connector != null) {
            return this.connector.connect(address, handler, initializer);
        }
        return null;
    }

    @Override
    public void connectDestroy(ResourceAddress address) {
        if (this.connector != null) {
            this.connector.connectDestroy(address);
        }
    }

    @Override
    public void dispose() {
        if (this.acceptor != null) {
            this.acceptor.dispose();
        }
        if (this.connector != null) {
            this.connector.dispose();
        }
    }

    public BridgeAcceptor getAcceptor() {
        return this.acceptor;
    }

    public BridgeConnector getConnector() {
        return this.connector;
    }

    public Transport getTransport() {
        return this.transport;
    }
}

