/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server;

import java.util.Collection;
import java.util.TreeSet;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.server.Gateway;
import org.kaazing.gateway.server.GatewayObserver;
import org.kaazing.gateway.server.context.GatewayContext;
import org.kaazing.gateway.service.AcceptOptionsContext;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.util.GL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(Gateway.class);
    private GatewayContext context;
    private final GatewayObserver gatewayListener;

    public Launcher(GatewayObserver gatewayListener) {
        this.gatewayListener = gatewayListener;
    }

    public void init(GatewayContext context) throws Exception {
        this.gatewayListener.startingGateway(context);
        try {
            this.initInternal(context);
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    private void initInternal(GatewayContext context) throws Exception {
        this.context = context;
        long startAt = System.currentTimeMillis();
        ClusterContext cluster = context.getCluster();
        if (cluster != null) {
            cluster.start();
        }
        TreeSet<String> mappedURIs = new TreeSet<String>();
        for (ServiceContext serviceContext : context.getServices()) {
            this.gatewayListener.initingService(serviceContext);
            serviceContext.init();
            this.gatewayListener.initedService(serviceContext);
        }
        for (ServiceContext serviceContext : context.getServices()) {
            this.gatewayListener.startingService(serviceContext);
            serviceContext.start();
            this.gatewayListener.startedService(serviceContext);
            AcceptOptionsContext ctx = serviceContext.getAcceptOptionsContext();
            Collection serviceAccepts = serviceContext.getAccepts();
            for (String serviceAccept : serviceAccepts) {
                String mappedURI = ctx.getInternalURI(serviceAccept);
                if (mappedURI == null || mappedURI.equals(serviceAccept)) {
                    mappedURIs.add(serviceAccept);
                    continue;
                }
                mappedURIs.add(serviceAccept + " @ " + URIUtils.getAuthority((String)mappedURI));
            }
        }
        long startedAt = System.currentTimeMillis();
        LOGGER.info("Starting server");
        if (!mappedURIs.isEmpty()) {
            LOGGER.info("Starting services");
            for (String mappedURI : mappedURIs) {
                LOGGER.info("  " + mappedURI);
            }
            LOGGER.info("Started services");
        }
        LOGGER.info("Started server successfully in " + String.format("%1$.3f secs", Float.valueOf((float)(startedAt - startAt) / 1000.0f)) + " at " + String.format("%1$tF %1$tT", startAt));
        if (cluster != null) {
            GL.debug((String)"ha", (String)"Exit Gateway launcher initInternal", (Object[])new Object[0]);
            cluster.logClusterStateAtInfoLevel();
        }
    }

    public void destroy() throws Exception {
        long stopAt = System.currentTimeMillis();
        TreeSet boundURIs = new TreeSet();
        for (ServiceContext serviceContext : this.context.getServices()) {
            boundURIs.addAll(serviceContext.getAccepts());
            try {
                this.gatewayListener.stopingService(serviceContext);
                serviceContext.stop();
                this.gatewayListener.stoppedService(serviceContext);
                this.gatewayListener.destroyingService(serviceContext);
                serviceContext.destroy();
                this.gatewayListener.destroyedService(serviceContext);
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Failed to stop service", (Throwable)e);
            }
        }
        this.gatewayListener.stoppedGateway(this.context);
        this.context.dispose();
        long stoppedAt = System.currentTimeMillis();
        LOGGER.info("Stopping server");
        if (!boundURIs.isEmpty()) {
            LOGGER.info("Stopping services");
            for (String boundURI : boundURIs) {
                LOGGER.info("  " + boundURI);
            }
            LOGGER.info("Stopped services");
        }
        LOGGER.info("Stopped server successfully in " + String.format("%1$.3f secs", Float.valueOf((float)(stoppedAt - stopAt) / 1000.0f)) + " at " + String.format("%1$tF %1$tT", stopAt));
    }

    public static Logger getGatewayStartupLogger() {
        return LOGGER;
    }
}

