/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.util.version;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.kaazing.gateway.server.util.version.DuplicateJarsException;
import org.kaazing.gateway.server.util.version.ManifestReader;
import org.slf4j.Logger;

public class DuplicateJarFinder {
    private static final String JAR_FILE_WITH_VERSION_LOGGING_MESSAGE = "The jar file {} with the version {} was loaded.";
    private static final String CONFLICTING_JARS_LOGGING_MESSAGE = "Failed to start because of conflicting versions of artifact on the classpath: {}.jar., with versions {}";
    private static final String MANIFEST_VERSION = "Implementation-Version";
    private static final String MANIFEST_JAR_NAME = "Artifact-Name";
    private ManifestReader classPathParser;
    private Logger gatewayLogger;

    public DuplicateJarFinder(Logger gatewayLogger) {
        this.gatewayLogger = gatewayLogger;
        this.classPathParser = new ManifestReader();
    }

    public void findDuplicateJars() throws IOException, DuplicateJarsException {
        HashMap<String, List<String>> artifactsToVersion = new HashMap<String, List<String>>();
        Enumeration<URL> manifestURLs = this.classPathParser.getManifestURLs();
        while (manifestURLs.hasMoreElements()) {
            this.parseManifestFileFromClassPathEntry(manifestURLs.nextElement(), artifactsToVersion);
        }
        this.checkForDuplicateJars(artifactsToVersion);
    }

    private void parseManifestFileFromClassPathEntry(URL url, Map<String, List<String>> artifactsToVersion) throws IOException {
        Attributes manifestAttributes = this.classPathParser.getManifestAttributesFromURL(url);
        String version = manifestAttributes.getValue(MANIFEST_VERSION);
        String artifactName = manifestAttributes.getValue(MANIFEST_JAR_NAME);
        if (this.isKaazingProduct(artifactName)) {
            List<String> versionList = artifactsToVersion.get(artifactName = artifactName.replace("com.kaazing:", "").replace("com.kaazing:", ""));
            if (versionList == null) {
                versionList = new ArrayList<String>();
                artifactsToVersion.put(artifactName, versionList);
            }
            versionList.add(version);
            this.gatewayLogger.debug(JAR_FILE_WITH_VERSION_LOGGING_MESSAGE, (Object)artifactName, (Object)version);
        }
    }

    private boolean isKaazingProduct(String product) {
        return product != null && (product.contains("org.kaazing") || product.contains("com.kaazing"));
    }

    private void checkForDuplicateJars(Map<String, List<String>> artifactsToVersion) throws DuplicateJarsException {
        for (String artifact : artifactsToVersion.keySet()) {
            List<String> versions = artifactsToVersion.get(artifact);
            if (versions.size() <= 1) continue;
            this.gatewayLogger.error(CONFLICTING_JARS_LOGGING_MESSAGE, (Object)artifact, versions);
            throw new DuplicateJarsException();
        }
    }

    void setClassPathParser(ManifestReader classPathParser) {
        this.classPathParser = classPathParser;
    }
}

