/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config.builder;

import java.io.File;
import java.util.Set;
import org.kaazing.gateway.server.test.config.ClusterConfiguration;
import org.kaazing.gateway.server.test.config.GatewayConfiguration;
import org.kaazing.gateway.server.test.config.NetworkConfiguration;
import org.kaazing.gateway.server.test.config.SecurityConfiguration;
import org.kaazing.gateway.server.test.config.ServiceConfiguration;
import org.kaazing.gateway.server.test.config.ServiceDefaultsConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.builder.AbstractClusterConfigurationBuilder;
import org.kaazing.gateway.server.test.config.builder.AbstractConfigurationBuilder;
import org.kaazing.gateway.server.test.config.builder.AbstractNetworkBuilder;
import org.kaazing.gateway.server.test.config.builder.AbstractSecurityConfigurationBuilder;
import org.kaazing.gateway.server.test.config.builder.AbstractServiceConfigurationBuilder;
import org.kaazing.gateway.server.test.config.builder.AbstractServiceDefaultsConfigurationBuilder;

public abstract class AbstractGatewayConfigurationBuilder<R>
extends AbstractConfigurationBuilder<GatewayConfiguration, R> {
    public AbstractGatewayConfigurationBuilder(GatewayConfiguration configuration, R result, Set<SuppressibleConfiguration.Suppression> suppressions) {
        super(configuration, result, suppressions);
    }

    public AbstractGatewayConfigurationBuilder<R> property(String name, String value) {
        ((GatewayConfiguration)this.configuration).getProperties().put(name, value);
        return this;
    }

    public AbstractGatewayConfigurationBuilder<R> webRootDirectory(File webRootDirectory) {
        ((GatewayConfiguration)this.configuration).setWebRootDirectory(webRootDirectory);
        return this;
    }

    public AbstractGatewayConfigurationBuilder<R> tempDirectory(File tempDirectory) {
        ((GatewayConfiguration)this.configuration).setTempDirectory(tempDirectory);
        return this;
    }

    public abstract AbstractSecurityConfigurationBuilder<? extends AbstractGatewayConfigurationBuilder<R>> security();

    public abstract AbstractServiceConfigurationBuilder<? extends AbstractGatewayConfigurationBuilder<R>> service();

    public abstract AbstractClusterConfigurationBuilder<? extends AbstractGatewayConfigurationBuilder<R>> cluster();

    public abstract AbstractServiceDefaultsConfigurationBuilder<? extends AbstractGatewayConfigurationBuilder<R>> serviceDefaults();

    public abstract AbstractNetworkBuilder<? extends AbstractGatewayConfigurationBuilder<R>> network();

    public AbstractGatewayConfigurationBuilder<R> suppress(SuppressibleConfiguration.Suppression ... suppressions) {
        super.addCurrentSuppressions(suppressions);
        return this;
    }

    public static class AddNetworkBuilder<R extends AbstractGatewayConfigurationBuilder<?>>
    extends AbstractNetworkBuilder<R> {
        protected AddNetworkBuilder(R result) {
            super(new NetworkConfiguration(), result);
        }

        @Override
        public R done() {
            ((GatewayConfiguration)((AbstractGatewayConfigurationBuilder)this.result).configuration).setNetwork((NetworkConfiguration)this.configuration);
            return (R)((AbstractGatewayConfigurationBuilder)super.done());
        }
    }

    public static class SetServiceDefaultsBuilder<R extends AbstractGatewayConfigurationBuilder<?>>
    extends AbstractServiceDefaultsConfigurationBuilder<R> {
        protected SetServiceDefaultsBuilder(R result, Set<SuppressibleConfiguration.Suppression> suppressions) {
            super(new ServiceDefaultsConfiguration(), result, suppressions);
        }

        @Override
        public R done() {
            ((GatewayConfiguration)((AbstractGatewayConfigurationBuilder)this.result).configuration).setServiceDefaults((ServiceDefaultsConfiguration)this.configuration);
            return (R)((AbstractGatewayConfigurationBuilder)super.done());
        }
    }

    public static class SetClusterBuilder<R extends AbstractGatewayConfigurationBuilder<?>>
    extends AbstractClusterConfigurationBuilder<R> {
        protected SetClusterBuilder(R result, Set<SuppressibleConfiguration.Suppression> suppressions) {
            super(new ClusterConfiguration(), result, suppressions);
        }

        @Override
        public R done() {
            ((GatewayConfiguration)((AbstractGatewayConfigurationBuilder)this.result).configuration).setCluster((ClusterConfiguration)this.configuration);
            return (R)((AbstractGatewayConfigurationBuilder)super.done());
        }
    }

    public static class AddServiceBuilder<R extends AbstractGatewayConfigurationBuilder<?>>
    extends AbstractServiceConfigurationBuilder<R> {
        protected AddServiceBuilder(R result, Set<SuppressibleConfiguration.Suppression> suppressions) {
            super(new ServiceConfiguration(), result, suppressions);
        }

        @Override
        public AbstractServiceConfigurationBuilder.AddCrossOriginConstraintBuilder<AddServiceBuilder<R>> crossOrigin() {
            return new AbstractServiceConfigurationBuilder.AddCrossOriginConstraintBuilder<AddServiceBuilder<R>>(this, this.getCurrentSuppressions());
        }

        @Override
        public AbstractServiceConfigurationBuilder.AddAuthorizationConstraintBuilder<AddServiceBuilder<R>> authorization() {
            return new AbstractServiceConfigurationBuilder.AddAuthorizationConstraintBuilder<AddServiceBuilder<R>>(this, this.getCurrentSuppressions());
        }

        @Override
        public AbstractServiceConfigurationBuilder.AddNestedPropertyBuilder<AddServiceBuilder<R>> nestedProperty(String propertyName) {
            return new AbstractServiceConfigurationBuilder.AddNestedPropertyBuilder<AddServiceBuilder<R>>(propertyName, this, this.getCurrentSuppressions());
        }

        @Override
        public R done() {
            ((GatewayConfiguration)((AbstractGatewayConfigurationBuilder)this.result).configuration).getServices().add((ServiceConfiguration)this.configuration);
            return (R)((AbstractGatewayConfigurationBuilder)super.done());
        }
    }

    public static class SetSecurityBuilder<R extends AbstractGatewayConfigurationBuilder<?>>
    extends AbstractSecurityConfigurationBuilder<R> {
        public SetSecurityBuilder(R result, Set<SuppressibleConfiguration.Suppression> suppressions) {
            super(new SecurityConfiguration(), result, suppressions);
        }

        @Override
        public AbstractSecurityConfigurationBuilder.AddRealmBuilder<SetSecurityBuilder<R>> realm() {
            return new AbstractSecurityConfigurationBuilder.AddRealmBuilder<SetSecurityBuilder<R>>(this, this.getCurrentSuppressions());
        }

        @Override
        public R done() {
            ((GatewayConfiguration)((AbstractGatewayConfigurationBuilder)this.result).configuration).setSecurity((SecurityConfiguration)this.configuration);
            return (R)((AbstractGatewayConfigurationBuilder)super.done());
        }
    }
}

