/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config;

import java.util.Set;
import org.kaazing.gateway.server.test.config.Configuration;
import org.kaazing.gateway.server.test.config.ConfigurationVisitor;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.SuppressibleCrossOriginConstraintConfiguration;
import org.kaazing.gateway.server.test.config.Suppressibles;

public class CrossOriginConstraintConfiguration
implements Configuration<SuppressibleCrossOriginConstraintConfiguration> {
    private final SuppressibleCrossOriginConstraintConfiguration _configuration = new SuppressibleCrossOriginConstraintConfigurationImpl();
    private Suppressible<String> _allowOrigin;
    private Suppressible<String> _allowMethods;
    private Suppressible<String> _allowHeaders;

    public CrossOriginConstraintConfiguration() {
        this._configuration.setSuppression(Suppressibles.getDefaultSuppressions());
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SuppressibleCrossOriginConstraintConfiguration getSuppressibleConfiguration() {
        return this._configuration;
    }

    public String getAllowOrigin() {
        if (this._allowOrigin == null) {
            return null;
        }
        return this._allowOrigin.value();
    }

    public void setAllowOrigin(String allowOrigin) {
        this._allowOrigin = new Suppressible<String>(allowOrigin, new SuppressibleConfiguration.Suppression[0]);
    }

    public String getAllowMethods() {
        if (this._allowMethods == null) {
            return null;
        }
        return this._allowMethods.value();
    }

    public void setAllowMethods(String allowMethods) {
        this._allowOrigin = new Suppressible<String>(allowMethods, new SuppressibleConfiguration.Suppression[0]);
    }

    public String getAllowHeaders() {
        if (this._allowHeaders == null) {
            return null;
        }
        return this._allowHeaders.value();
    }

    public void setAllowHeaders(String allowHeaders) {
        this._allowOrigin = new Suppressible<String>(allowHeaders, new SuppressibleConfiguration.Suppression[0]);
    }

    private class SuppressibleCrossOriginConstraintConfigurationImpl
    extends SuppressibleCrossOriginConstraintConfiguration {
        private Set<SuppressibleConfiguration.Suppression> _suppressions;

        private SuppressibleCrossOriginConstraintConfigurationImpl() {
        }

        @Override
        public Set<SuppressibleConfiguration.Suppression> getSuppressions() {
            return this._suppressions;
        }

        @Override
        public void setSuppression(Set<SuppressibleConfiguration.Suppression> suppressions) {
            this._suppressions = suppressions;
        }

        @Override
        public Suppressible<String> getAllowOrigin() {
            return CrossOriginConstraintConfiguration.this._allowOrigin;
        }

        @Override
        public void setAllowOrigin(Suppressible<String> allowOrigin) {
            CrossOriginConstraintConfiguration.this._allowOrigin = allowOrigin;
        }

        @Override
        public Suppressible<String> getAllowMethods() {
            return CrossOriginConstraintConfiguration.this._allowMethods;
        }

        @Override
        public void setAllowMethods(Suppressible<String> allowMethods) {
            CrossOriginConstraintConfiguration.this._allowMethods = allowMethods;
        }

        @Override
        public Suppressible<String> getAllowHeaders() {
            return CrossOriginConstraintConfiguration.this._allowHeaders;
        }

        @Override
        public void setAllowHeaders(Suppressible<String> allowHeaders) {
            CrossOriginConstraintConfiguration.this._allowHeaders = allowHeaders;
        }
    }
}

