/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.messaging.buffer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kaazing.gateway.service.messaging.buffer.MessageBufferEntry;
import org.kaazing.gateway.service.messaging.buffer.MessageBufferListener;
import org.kaazing.gateway.util.GL;

public class MessageBufferListenerSupport
implements MessageBufferListener {
    private final Map<MessageBufferListener, MessageBufferListener> listeners = new ConcurrentHashMap<MessageBufferListener, MessageBufferListener>();

    public void addMessageBufferListener(MessageBufferListener listener) {
        this.listeners.put(listener, listener);
    }

    public void removeMessageBufferListener(MessageBufferListener listener) {
        this.listeners.remove(listener);
    }

    public void messageAdded(MessageBufferEntry newMessage) {
        for (MessageBufferListener listener : this.listeners.keySet()) {
            try {
                listener.messageAdded(newMessage);
            }
            catch (Exception e) {
                GL.warn((String)"stompservice", (String)"Unable to process message buffer listener:\n{}", (Object[])new Object[]{e});
            }
        }
    }
}

