/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Properties;
import org.kaazing.gateway.server.Gateway;
import org.kaazing.gateway.server.impl.GatewayCreator;
import org.kaazing.gateway.server.impl.GatewayImpl;

public class GatewayCreatorImpl
implements GatewayCreator {
    public Gateway createGateway(Gateway gateway) {
        return new GatewayImpl(gateway);
    }

    public void configureGateway(Gateway gateway) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        String gatewayHome = properties.getProperty("GATEWAY_HOME");
        if (gatewayHome == null || "".equals(gatewayHome)) {
            String urlStr;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL classUrl = loader.getResource("org/kaazing/gateway/server/Gateway.class");
            try {
                urlStr = URLDecoder.decode(classUrl.toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Failed to configure Gateway", ex);
            }
            int packageSeparatorIndex = urlStr.indexOf("!/");
            if (packageSeparatorIndex > 0) {
                urlStr = urlStr.substring(0, urlStr.indexOf("!/"));
                urlStr = urlStr.substring(4);
            }
            if (!urlStr.startsWith("file:")) {
                throw new RuntimeException("The Gateway class was not loaded from a file, so we cannot determine the location of GATEWAY_HOME");
            }
            urlStr = urlStr.substring(5);
            File jarFile = new File(urlStr);
            gatewayHome = jarFile.getParentFile().getParent();
            properties.setProperty("GATEWAY_HOME", gatewayHome);
        }
        gateway.setProperties(properties);
    }
}

