/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.messaging.buffer;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.kaazing.gateway.server.messaging.buffer.MemoryMessageBuffer;
import org.kaazing.gateway.service.messaging.MessagingMessage;
import org.kaazing.gateway.service.messaging.buffer.MessageBuffer;
import org.kaazing.gateway.service.messaging.buffer.MessageBufferEntry;
import org.kaazing.gateway.service.messaging.buffer.MessageBufferListener;
import org.kaazing.gateway.util.GL;
import org.kaazing.gateway.util.Utils;

public class ClusterMemoryMessageBuffer
implements MessageBuffer,
Serializable {
    private static final long serialVersionUID = 1L;
    private String topicName;
    private transient MessageBuffer buffer;
    private transient ITopic<MessageBufferEntry> topic;
    private HazelcastInstance cluster;

    protected ClusterMemoryMessageBuffer() {
    }

    public ClusterMemoryMessageBuffer(HazelcastInstance cluster, int capacity) {
        this.cluster = cluster;
        this.topicName = Utils.randomHexString((int)8);
        GL.debug((String)"messaging", (String)"Creating cluster message buffer {}", (Object[])new Object[]{this.topicName});
        this.init(capacity);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.buffer.getCapacity());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int capacity = in.readInt();
        this.init(capacity);
    }

    private void init(int capacity) {
        this.buffer = new MemoryMessageBuffer(capacity);
        GL.debug((String)"messaging", (String)"Cluster message buffer listening on {}", (Object[])new Object[]{this.topicName});
        this.topic = this.cluster.getTopic(this.topicName);
        this.topic.addMessageListener((MessageListener)new MessageListener<MessageBufferEntry>(){

            public void onMessage(MessageBufferEntry entry) {
                if (entry == null) {
                    GL.debug((String)"messaing", (String)"Received null entry", (Object[])new Object[0]);
                    return;
                }
                int id = entry.getId();
                if (id > ClusterMemoryMessageBuffer.this.buffer.getYoungestId()) {
                    GL.debug((String)"messaging", (String)"Received message entry {}", (Object[])new Object[]{entry});
                    ClusterMemoryMessageBuffer.this.buffer.set(id, entry.getMessage());
                }
            }
        });
    }

    public MessageBufferEntry add(MessagingMessage message) {
        GL.debug((String)"messaging", (String)"Received message {}", (Object[])new Object[]{message});
        MessageBufferEntry entry = this.buffer.add(message);
        if (entry != null) {
            this.topic.publish((Object)entry);
        } else {
            GL.debug((String)"messaging", (String)"Got null entry from {}", (Object[])new Object[]{this.buffer});
        }
        return entry;
    }

    public MessageBufferEntry get(int id) {
        return this.buffer.get(id);
    }

    public MessageBufferEntry set(int index, MessagingMessage message) {
        return this.buffer.set(index, message);
    }

    public int getYoungestId() {
        return this.buffer.getYoungestId();
    }

    public int getOldestId() {
        return this.buffer.getOldestId();
    }

    public int getCapacity() {
        return this.buffer.getCapacity();
    }

    public void addMessageBufferListener(MessageBufferListener listener) {
        this.buffer.addMessageBufferListener(listener);
    }

    public void removeMessageBufferListener(MessageBufferListener listener) {
        this.buffer.removeMessageBufferListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[topicName=").append(this.topicName).append(",youngestId=").append(this.buffer.getYoungestId()).append(']');
        return sb.toString();
    }
}

