/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.kaazing.gateway.server.test.Gateway;
import org.kaazing.gateway.server.test.config.GatewayConfiguration;

public class GatewayClusterRule
implements TestRule {
    private List<GatewayConfiguration> configurations;
    private List<Gateway> gateways = new ArrayList<Gateway>();
    private Map<GatewayConfiguration, Gateway> gatewaysByConfiguration = new HashMap<GatewayConfiguration, Gateway>();
    private String log4jPropertiesResourceName;

    public Statement apply(Statement base, Description description) {
        return new GatewayStatement(base);
    }

    public void init(GatewayConfiguration ... configurations) {
        this.configurations = Arrays.asList(configurations);
    }

    public void init(List<GatewayConfiguration> configurations) {
        this.configurations = configurations;
    }

    public void init(List<GatewayConfiguration> configurations, String log4jPropertiesResourceName) {
        this.init(configurations);
        this.log4jPropertiesResourceName = log4jPropertiesResourceName;
    }

    public Gateway getGateway(GatewayConfiguration configuration) {
        return this.gatewaysByConfiguration.get(configuration);
    }

    private final class GatewayStatement
    extends Statement {
        private final Statement base;

        public GatewayStatement(Statement base) {
            this.base = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            if (GatewayClusterRule.this.log4jPropertiesResourceName != null) {
                Properties log4j = new Properties();
                InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(GatewayClusterRule.this.log4jPropertiesResourceName);
                if (in == null) {
                    throw new IOException(String.format("Could not load resource %s", GatewayClusterRule.this.log4jPropertiesResourceName));
                }
                log4j.load(in);
                PropertyConfigurator.configure((Properties)log4j);
            }
            try {
                for (GatewayConfiguration configuration : GatewayClusterRule.this.configurations) {
                    Gateway gateway = new Gateway();
                    gateway.start(configuration);
                    GatewayClusterRule.this.gateways.add(gateway);
                    GatewayClusterRule.this.gatewaysByConfiguration.put(configuration, gateway);
                }
                this.base.evaluate();
            }
            finally {
                for (Gateway gateway : GatewayClusterRule.this.gateways) {
                    gateway.stop();
                }
            }
        }
    }
}

