/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.service;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.server.service.ServiceAuthority;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.ServiceRegistration;

public class ServiceRegistry {
    private final Map<String, ServiceAuthority> entries = new HashMap<String, ServiceAuthority>();

    public ServiceAuthority register(String authority, ServiceAuthority value) {
        return this.entries.put(authority, value);
    }

    public ServiceAuthority unregister(String authority) {
        return this.entries.remove(authority);
    }

    public ServiceAuthority lookup(String authority) {
        return this.entries.get(authority);
    }

    public ServiceContext register(String serviceURI, ServiceContext serviceContext) {
        ServiceRegistration serviceRegistration;
        if (URIUtils.getQuery((String)serviceURI) != null || URIUtils.getFragment((String)serviceURI) != null) {
            throw new IllegalArgumentException("Service URI query and fragment must be null");
        }
        ServiceAuthority serviceAuthority = this.entries.get(URIUtils.getAuthority((String)serviceURI));
        if (serviceAuthority == null) {
            serviceAuthority = new ServiceAuthority();
            this.entries.put(URIUtils.getAuthority((String)serviceURI), serviceAuthority);
        }
        return (serviceRegistration = serviceAuthority.register(serviceURI, serviceContext)) != null ? serviceRegistration.getServiceContext() : null;
    }

    public ServiceContext unregister(URI serviceURI) {
        if (serviceURI.getQuery() != null || serviceURI.getFragment() != null) {
            throw new IllegalArgumentException("Service URI query and fragment must be null");
        }
        ServiceAuthority serviceAuthority = this.entries.get(serviceURI.getAuthority());
        if (serviceAuthority == null) {
            return null;
        }
        ServiceRegistration serviceRegistration = serviceAuthority.unregister(serviceURI);
        return serviceRegistration != null ? serviceRegistration.getServiceContext() : null;
    }

    public ServiceRegistration lookup(URI serviceURI) {
        ServiceAuthority serviceAuthority = this.entries.get(serviceURI.getAuthority());
        if (serviceAuthority != null) {
            ServiceRegistration serviceRegistration = serviceAuthority.lookup(serviceURI);
            return serviceRegistration;
        }
        return null;
    }

    public Collection<ServiceAuthority> values() {
        return this.entries.values();
    }
}

