/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.Join;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LogListener;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.kaazing.gateway.resource.address.ResolutionUtils;
import org.kaazing.gateway.server.messaging.buffer.ClusterMemoryMessageBufferFactory;
import org.kaazing.gateway.server.messaging.collections.ClusterCollectionsFactory;
import org.kaazing.gateway.service.cluster.BalancerMapListener;
import org.kaazing.gateway.service.cluster.ClusterConnectOptionsContext;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.service.cluster.ClusterMessaging;
import org.kaazing.gateway.service.cluster.InstanceKeyListener;
import org.kaazing.gateway.service.cluster.MemberId;
import org.kaazing.gateway.service.cluster.MembershipEventListener;
import org.kaazing.gateway.service.cluster.ReceiveListener;
import org.kaazing.gateway.service.cluster.SendListener;
import org.kaazing.gateway.service.messaging.buffer.MessageBufferFactory;
import org.kaazing.gateway.service.messaging.collections.CollectionsFactory;
import org.kaazing.gateway.util.GL;
import org.kaazing.gateway.util.Utils;
import org.kaazing.gateway.util.aws.AwsUtils;
import org.kaazing.gateway.util.scheduler.SchedulerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterContext
implements ClusterContext,
LogListener {
    private static final String CLUSTER_LOG_FORMAT = "HAZELCAST: [%s] - %s";
    private static final String INSTANCE_KEY_MAP = "instanceKeyMap";
    private final Logger logger = LoggerFactory.getLogger((String)"ha");
    private final String localInstanceKey = Utils.randomHexString((int)16);
    private MessageBufferFactory messageBufferFactory;
    private CollectionsFactory collectionsFactory;
    private List<MemberId> localInterfaces = new ArrayList<MemberId>();
    private final List<MemberId> clusterMembers = new ArrayList<MemberId>();
    private final List<MembershipEventListener> membershipEventListeners = new ArrayList<MembershipEventListener>();
    private final List<InstanceKeyListener> instanceKeyListeners = new ArrayList<InstanceKeyListener>();
    private final List<BalancerMapListener> balancerMapListeners = new ArrayList<BalancerMapListener>();
    private ClusterMessaging clusterMessaging;
    private MemberId localNodeId;
    private final String clusterName;
    private HazelcastInstance clusterInstance;
    private final SchedulerProvider schedulerProvider;
    private final ClusterConnectOptionsContext connectOptions;
    private final AtomicBoolean clusterInitialized = new AtomicBoolean(false);
    private MembershipListener membershipListener = new MembershipListener(){

        public void memberAdded(MembershipEvent membershipEvent) {
            MemberId newMemberId = DefaultClusterContext.this.getMemberId(membershipEvent.getMember());
            GL.info((String)"ha", (String)"Cluster member {} is now online", (Object[])new Object[]{newMemberId.getId()});
            DefaultClusterContext.this.fireMemberAdded(newMemberId);
            GL.info((String)"ha", (String)"Member Added", (Object[])new Object[0]);
            DefaultClusterContext.this.logClusterStateAtInfoLevel();
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            MemberId removedMember = DefaultClusterContext.this.getMemberId(membershipEvent.getMember());
            GL.info((String)"ha", (String)"Cluster member {} has gone down", (Object[])new Object[]{removedMember});
            IMap instanceKeyMap = DefaultClusterContext.this.getCollectionsFactory().getMap(DefaultClusterContext.INSTANCE_KEY_MAP);
            instanceKeyMap.remove(removedMember);
            IMap memberIdBalancerUriMap = DefaultClusterContext.this.getCollectionsFactory().getMap("memberIdBalancerMap");
            if (memberIdBalancerUriMap == null) {
                throw new IllegalStateException("MemberId to BalancerMap is null");
            }
            IMap sharedBalanceUriMap = DefaultClusterContext.this.getCollectionsFactory().getMap("balancerMap");
            if (sharedBalanceUriMap == null) {
                throw new IllegalStateException("Shared balanced URIs map is null");
            }
            Map memberBalancedUrisMap = (Map)memberIdBalancerUriMap.remove(removedMember);
            if (memberBalancedUrisMap != null) {
                GL.debug((String)"ha", (String)"Cleaning up balancer cluster state for member {}", (Object[])new Object[]{removedMember});
                try {
                    for (String key : memberBalancedUrisMap.keySet()) {
                        GL.debug((String)"ha", (String)"URI Key: {}", (Object[])new Object[]{key});
                        List memberBalancedUris = (List)memberBalancedUrisMap.get(key);
                        TreeSet globalBalancedUris = null;
                        TreeSet newGlobalBalancedUris = null;
                        do {
                            globalBalancedUris = (TreeSet)sharedBalanceUriMap.get((Object)key);
                            newGlobalBalancedUris = new TreeSet(globalBalancedUris);
                            for (String memberBalancedUri : memberBalancedUris) {
                                GL.debug((String)"ha", (String)"Attempting to removing Balanced URI : {}", (Object[])new Object[]{memberBalancedUri});
                                newGlobalBalancedUris.remove(memberBalancedUri);
                            }
                        } while (!sharedBalanceUriMap.replace((Object)key, (Object)globalBalancedUris, newGlobalBalancedUris));
                        GL.debug((String)"ha", (String)"Removed balanced URIs for cluster member {}, new global list: {}", (Object[])new Object[]{removedMember, newGlobalBalancedUris});
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to remove the balanced URIs served by the member going down from global map");
                }
            }
            DefaultClusterContext.this.fireMemberRemoved(removedMember);
            GL.info((String)"ha", (String)"Member Removed", (Object[])new Object[0]);
            DefaultClusterContext.this.logClusterStateAtInfoLevel();
        }
    };
    private EntryListener<MemberId, String> instanceKeyEntryListener = new EntryListener<MemberId, String>(){

        public void entryAdded(EntryEvent<MemberId, String> newEntryEvent) {
            DefaultClusterContext.this.fireInstanceKeyAdded((String)newEntryEvent.getValue());
        }

        public void entryEvicted(EntryEvent<MemberId, String> evictedEntryEvent) {
            throw new RuntimeException("Instance keys should not be evicted, only added or removed.");
        }

        public void entryRemoved(EntryEvent<MemberId, String> removedEntryEvent) {
            DefaultClusterContext.this.fireInstanceKeyRemoved((String)removedEntryEvent.getValue());
        }

        public void entryUpdated(EntryEvent<MemberId, String> updatedEntryEvent) {
            throw new RuntimeException("Instance keys can not be updated, only added or removed.");
        }
    };
    private EntryListener<String, Collection<String>> balancerMapEntryListener = new EntryListener<String, Collection<String>>(){

        public void entryAdded(EntryEvent<String, Collection<String>> newEntryEvent) {
            GL.trace((String)"ha", (String)"New entry for balance URI: {}   value: {}", (Object[])new Object[]{newEntryEvent.getKey(), newEntryEvent.getValue()});
            DefaultClusterContext.this.fireBalancerEntryAdded((EntryEvent<String, Collection<String>>)newEntryEvent);
        }

        public void entryEvicted(EntryEvent<String, Collection<String>> evictedEntryEvent) {
            throw new RuntimeException("Balancer map entries should not be evicted, only added or removed.");
        }

        public void entryRemoved(EntryEvent<String, Collection<String>> removedEntryEvent) {
            GL.trace((String)"ha", (String)"Entry removed for balance URI: {}   value: {}", (Object[])new Object[]{removedEntryEvent.getKey(), removedEntryEvent.getValue()});
            DefaultClusterContext.this.fireBalancerEntryRemoved((EntryEvent<String, Collection<String>>)removedEntryEvent);
        }

        public void entryUpdated(EntryEvent<String, Collection<String>> updatedEntryEvent) {
            GL.trace((String)"ha", (String)"Entry updated for balance URI: {}   value: {}", (Object[])new Object[]{updatedEntryEvent.getKey(), updatedEntryEvent.getValue()});
            DefaultClusterContext.this.fireBalancerEntryUpdated((EntryEvent<String, Collection<String>>)updatedEntryEvent);
        }
    };

    public DefaultClusterContext(String name, List<MemberId> interfaces, List<MemberId> members, SchedulerProvider schedulerProvider) {
        this(name, interfaces, members, schedulerProvider, null);
    }

    public DefaultClusterContext(String name, List<MemberId> interfaces, List<MemberId> members, SchedulerProvider schedulerProvider, ClusterConnectOptionsContext connectOptions) {
        this.clusterName = name;
        this.localInterfaces.addAll(interfaces);
        this.clusterMembers.addAll(members);
        this.schedulerProvider = schedulerProvider;
        this.connectOptions = connectOptions;
    }

    public void start() {
        if (this.localInterfaces.size() + this.clusterMembers.size() == 0) {
            if (this.localInterfaces.size() == 0) {
                GL.info((String)"ha", (String)"No network interfaces specified in the gateway configuration", (Object[])new Object[0]);
                throw new IllegalArgumentException("No network interfaces specified in the gateway configuration");
            }
            if (this.clusterMembers.size() == 0) {
                GL.info((String)"ha", (String)"No cluster members specified in the gateway configuration", (Object[])new Object[0]);
                throw new IllegalArgumentException("No cluster members specified in the gateway configuration");
            }
        }
        try {
            Config config = this.initializeHazelcastConfig();
            this.initializeCluster(config);
            GL.info((String)"ha", (String)"Cluster Member started: IP Address: {}; Port: {}; id: {}", (Object[])new Object[]{this.localNodeId.getHost(), this.localNodeId.getPort(), this.localNodeId.getId()});
        }
        catch (Exception e) {
            GL.error((String)"ha", (String)"Unable to initialize cluster due to an exception: {}", (Object[])new Object[]{e});
            throw new RuntimeException(String.format("Unable to initialize cluster due to an exception: %s", e), e);
        }
    }

    public void dispose() {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.destroy();
        }
        if (this.clusterInstance != null) {
            this.clusterInstance.getLifecycleService().shutdown();
        }
    }

    private Config initializeHazelcastConfig() throws Exception {
        Config hazelCastConfig = new Config();
        hazelCastConfig.getGroupConfig().setName(this.getClusterName());
        hazelCastConfig.getGroupConfig().setPassword("5942");
        MapConfig mapConfig = hazelCastConfig.getMapConfig("serverSessions");
        mapConfig.setBackupCount(3);
        MapConfig sharedBalancerMapConfig = hazelCastConfig.getMapConfig("balancerMap");
        sharedBalancerMapConfig.setBackupCount(Integer.MAX_VALUE);
        MapConfig memberBalancerMapConfig = hazelCastConfig.getMapConfig("memberIdBalancerMap");
        memberBalancerMapConfig.setBackupCount(Integer.MAX_VALUE);
        hazelCastConfig.setPortAutoIncrement(false);
        int clusterPort = this.localInterfaces.size() > 0 ? this.localInterfaces.get(0).getPort() : -1;
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger("com.hazelcast");
        logger.setLevel(Level.OFF);
        if (clusterPort != -1) {
            hazelCastConfig.setPort(clusterPort);
        }
        NetworkConfig networkConfig = new NetworkConfig();
        for (MemberId localInterface : this.localInterfaces) {
            String protocol = localInterface.getProtocol();
            if ("udp".equalsIgnoreCase(protocol) || "aws".equalsIgnoreCase(protocol)) {
                throw new IllegalArgumentException("Cannot accept on a multicast or aws address, use unicast address starting with tcp://");
            }
            String hostAddress = localInterface.getHost();
            InetAddress address = this.getResolvedAddressFromHost(hostAddress);
            if (address instanceof Inet6Address) {
                throw new IllegalArgumentException("ERROR: Cluster member accept url - '" + localInterface.toString() + "' consists of IPv6 address which is not supported. Use Ipv4 address instead.");
            }
            String hostConvertedToIP = this.convertHostToIP(localInterface.getHost());
            networkConfig.getInterfaces().addInterface(hostConvertedToIP);
            if (localInterface.getPort() == clusterPort) continue;
            throw new IllegalArgumentException("Port numbers on the network interfaces in <accept> do not match");
        }
        boolean usingMulticast = false;
        Join joinConfig = networkConfig.getJoin();
        MulticastConfig multicastConfig = joinConfig.getMulticastConfig();
        multicastConfig.setEnabled(false);
        TcpIpConfig tcpIpConfig = joinConfig.getTcpIpConfig();
        ArrayList<InetSocketAddress> multicastAddresses = new ArrayList<InetSocketAddress>();
        ArrayList<InetSocketAddress> unicastAddresses = new ArrayList<InetSocketAddress>();
        MemberId awsMember = null;
        for (MemberId member : this.clusterMembers) {
            if (member.getProtocol().equals("udp")) {
                multicastAddresses.add(new InetSocketAddress(this.convertHostToIP(member.getHost()), member.getPort()));
                continue;
            }
            if (member.getProtocol().equals("tcp")) {
                unicastAddresses.add(new InetSocketAddress(this.convertHostToIP(member.getHost()), member.getPort()));
                continue;
            }
            if (!member.getProtocol().equals("aws")) continue;
            awsMember = member;
        }
        if (awsMember == null) {
            int multicastAddressesCount = multicastAddresses.size();
            if (multicastAddressesCount > 1) {
                throw new IllegalArgumentException("Conflicting multicast discovery addresses in cluster configuration");
            }
            if (multicastAddressesCount > 0) {
                if (AwsUtils.isDeployedToAWS()) {
                    throw new IllegalArgumentException("Multicast cluster configuration not supported on AWS, use aws://security-group/<security-group-name> in connect tag");
                }
                multicastConfig.setEnabled(true);
                InetSocketAddress multicastAddress = (InetSocketAddress)multicastAddresses.get(0);
                multicastConfig.setMulticastGroup(multicastAddress.getHostName());
                multicastConfig.setMulticastPort(multicastAddress.getPort());
            }
            if (unicastAddresses.size() > 0) {
                tcpIpConfig.setEnabled(!usingMulticast);
                for (InetSocketAddress inetSocketAddress : unicastAddresses) {
                    tcpIpConfig.addAddress(new Address(inetSocketAddress));
                }
            }
            boolean useAnyAddress = false;
            for (String networkInterface : networkConfig.getInterfaces().getInterfaces()) {
                InetAddress address = this.getResolvedAddressFromHost(networkInterface);
                if (!address.isAnyLocalAddress()) continue;
                useAnyAddress = true;
                break;
            }
            if (!useAnyAddress) {
                networkConfig.getInterfaces().setEnabled(true);
                hazelCastConfig.setProperty("hazelcast.socket.bind.any", "false");
            }
        } else {
            String path = awsMember.getPath();
            String groupName = null;
            if (path != null && path.indexOf("/") == 0 && path.length() > 1) {
                groupName = path.substring(1, path.length());
            }
            if (groupName == null || groupName.length() == 0) {
                groupName = AwsUtils.getSecurityGroupName();
            }
            multicastConfig.setEnabled(false);
            tcpIpConfig.setEnabled(false);
            AwsConfig awsConfig = joinConfig.getAwsConfig();
            awsConfig.setEnabled(true);
            awsConfig.setAccessKey(this.connectOptions.getAwsAccessKeyId());
            awsConfig.setSecretKey(this.connectOptions.getAwsSecretKey());
            awsConfig.setRegion(AwsUtils.getRegion());
            awsConfig.setSecurityGroupName(groupName);
            String localIPv4 = AwsUtils.getLocalIPv4();
            networkConfig.getInterfaces().setEnabled(true);
            networkConfig.getInterfaces().clear();
            networkConfig.getInterfaces().addInterface(localIPv4);
            hazelCastConfig.setProperty("hazelcast.socket.bind.any", "false");
        }
        hazelCastConfig.setNetworkConfig(networkConfig);
        hazelCastConfig.setProperty("hazelcast.shutdownhook.enabled", "false");
        return hazelCastConfig;
    }

    private String convertHostToIP(String host) throws UnknownHostException {
        return this.getResolvedAddressFromHost(host).getHostAddress();
    }

    private List<String> processInterfaceOrMemberEntry(String entry) {
        if (entry == null) {
            return null;
        }
        ArrayList<String> addresses = new ArrayList<String>();
        int starIndex = entry.indexOf(42);
        int dashIndex = entry.indexOf(45);
        if (starIndex == -1 && dashIndex == -1) {
            addresses.add(entry);
            return addresses;
        }
        String[] parts = entry.split("\\.");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid wildcard in the entry for cluster configuration: " + entry);
        }
        if (parts[0].contains("*") && parts[0].contains("-")) {
            throw new IllegalArgumentException("Invalid wildcard in the entry for cluster configuration, first part of the address cannot contain a wildcard: " + entry);
        }
        String part1 = parts[0];
        String[] part2s = this.processEntryPart(entry, parts[1]);
        String[] part3s = this.processEntryPart(entry, parts[2]);
        String[] part4s = this.processEntryPart(entry, parts[3]);
        for (int i = 0; i < part2s.length; ++i) {
            for (int j = 0; j < part3s.length; ++j) {
                for (int k = 0; k < part4s.length; ++k) {
                    addresses.add(part1 + "." + part2s[i] + "." + part3s[j] + "." + part4s[k]);
                }
            }
        }
        return addresses;
    }

    private InetAddress getResolvedAddressFromHost(String hostAddress) throws UnknownHostException {
        InetAddress address = null;
        Collection addresses = ResolutionUtils.getAllByName((String)hostAddress, (boolean)false);
        address = addresses.isEmpty() ? InetAddress.getByName(hostAddress) : (InetAddress)addresses.iterator().next();
        return address;
    }

    private String[] processEntryPart(String entry, String ipPart) {
        if (!ipPart.contains("*") && !ipPart.contains("-")) {
            String[] resolvedParts = new String[]{ipPart};
            return resolvedParts;
        }
        if (ipPart.equals("*")) {
            String[] resolvedParts = new String[256];
            for (int i = 0; i < 256; ++i) {
                resolvedParts[i] = String.valueOf(i);
            }
            return resolvedParts;
        }
        if (ipPart.contains("-")) {
            String[] rangeParts = ipPart.split("-");
            if (rangeParts.length != 2) {
                throw new IllegalArgumentException("Invalid wildcard in the entry for cluster configuration: " + entry);
            }
            int start = Integer.parseInt(rangeParts[0]);
            int end = Integer.parseInt(rangeParts[1]);
            String[] resolvedParts = new String[end - start + 1];
            for (int i = start; i <= end; ++i) {
                resolvedParts[i] = String.valueOf(i);
            }
            return resolvedParts;
        }
        throw new IllegalArgumentException("Invalid wildcard in the entry for cluster configuration: " + entry);
    }

    public MemberId getLocalMember() {
        return this.localNodeId;
    }

    public Collection<MemberId> getMemberIds() {
        IMap instanceKeyMap = this.getCollectionsFactory().getMap(INSTANCE_KEY_MAP);
        return instanceKeyMap.keySet();
    }

    private MemberId getMemberId(Member member) {
        InetSocketAddress inetSocketAddress = member.getInetSocketAddress();
        String hostname = inetSocketAddress.getHostName();
        if (!inetSocketAddress.isUnresolved()) {
            String ipAddr;
            hostname = ipAddr = inetSocketAddress.getAddress().getHostAddress();
            GL.debug((String)"ha", (String)"getMemberId: Hostname: {}; IP Address: {}", (Object[])new Object[]{hostname, ipAddr});
        }
        return new MemberId("tcp", hostname, inetSocketAddress.getPort());
    }

    public String getInstanceKey(MemberId memberId) {
        if (memberId == this.localNodeId) {
            return this.localInstanceKey;
        }
        IMap instanceKeyMap = this.getCollectionsFactory().getMap(INSTANCE_KEY_MAP);
        return (String)instanceKeyMap.get(memberId);
    }

    public Lock getLock(Object obj) {
        return this.clusterInstance.getLock(obj);
    }

    public IdGenerator getIdGenerator(String name) {
        return this.clusterInstance.getIdGenerator(name);
    }

    public void addReceiveQueue(String name) {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.addReceiveQueue(name);
        }
    }

    public void addReceiveTopic(String name) {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.addReceiveTopic(name);
        }
    }

    public void send(Object msg, SendListener listener, MemberId member) {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.send(msg, listener, member);
        }
    }

    public void send(Object msg, SendListener listener, String name) {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.send(msg, listener, name);
        }
    }

    public Object send(Object msg, MemberId member) throws Exception {
        if (this.clusterMessaging != null) {
            return this.clusterMessaging.send(msg, member);
        }
        return null;
    }

    public Object send(Object msg, String name) throws Exception {
        if (this.clusterMessaging != null) {
            return this.clusterMessaging.send(msg, name);
        }
        return null;
    }

    public <T> void setReceiver(Class<T> type, ReceiveListener<T> receiveListener) {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.setReceiver(type, receiveListener);
        }
    }

    public <T> void removeReceiver(Class<T> type) {
        if (this.clusterMessaging != null) {
            this.clusterMessaging.removeReceiver(type);
        }
    }

    public void addMembershipEventListener(MembershipEventListener eventListener) {
        if (eventListener != null) {
            this.membershipEventListeners.add(eventListener);
            GL.debug((String)"ha", (String)"MemberShipEventListener Added", (Object[])new Object[0]);
        }
    }

    public void removeMembershipEventListener(MembershipEventListener eventListener) {
        if (eventListener != null) {
            this.membershipEventListeners.remove(eventListener);
        }
    }

    public void addInstanceKeyListener(InstanceKeyListener instanceKeyListener) {
        if (instanceKeyListener != null) {
            this.instanceKeyListeners.add(instanceKeyListener);
        }
    }

    public void removeInstanceKeyListener(InstanceKeyListener instanceKeyListener) {
        if (instanceKeyListener != null) {
            this.instanceKeyListeners.remove(instanceKeyListener);
        }
    }

    public void addBalancerMapListener(BalancerMapListener balancerMapListener) {
        if (balancerMapListener != null) {
            this.balancerMapListeners.add(balancerMapListener);
            GL.debug((String)"ha", (String)"Add balancerMapListener", (Object[])new Object[0]);
        }
        GL.debug((String)"ha", (String)"Exit Add balancerMapListener", (Object[])new Object[0]);
    }

    public void removeBalancerMapListener(BalancerMapListener balancerMapListener) {
        if (balancerMapListener != null) {
            this.balancerMapListeners.remove(balancerMapListener);
            GL.debug((String)"ha", (String)"Remove balancerMapListener", (Object[])new Object[0]);
        }
        GL.debug((String)"ha", (String)"Exit Remove balancerMapListener", (Object[])new Object[0]);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public List<MemberId> getAccepts() {
        return this.localInterfaces;
    }

    public List<MemberId> getConnects() {
        return this.clusterMembers;
    }

    public ClusterConnectOptionsContext getConnectOptions() {
        return this.connectOptions;
    }

    public MessageBufferFactory getMessageBufferFactory() {
        return this.messageBufferFactory;
    }

    public void logClusterState() {
        this.logClusterMembers();
        this.logBalancerMap();
    }

    public void logClusterStateAtInfoLevel() {
        Cluster cluster;
        if (this.clusterInstance != null && (cluster = this.clusterInstance.getCluster()) != null) {
            GL.info((String)"ha", (String)"Current cluster members:", (Object[])new Object[0]);
            Set currentMembers = this.clusterInstance.getCluster().getMembers();
            for (Member currentMember : currentMembers) {
                MemberId memberId = this.getMemberId(currentMember);
                GL.info((String)"ha", (String)"      member: {}", (Object[])new Object[]{memberId});
            }
        }
        GL.info((String)"ha", (String)"Current shared balancer map:", (Object[])new Object[0]);
        IMap balancerMap = this.getCollectionsFactory().getMap("balancerMap");
        for (String balanceURI : balancerMap.keySet()) {
            Set balanceTargets = (Set)balancerMap.get(balanceURI);
            GL.info((String)"ha", (String)"     balance URI: {}    target list: {}", (Object[])new Object[]{balanceURI, balanceTargets});
        }
    }

    private void logClusterMembers() {
        Cluster cluster;
        if (this.clusterInstance != null && (cluster = this.clusterInstance.getCluster()) != null) {
            GL.trace((String)"ha", (String)"Current cluster members:", (Object[])new Object[0]);
            Set currentMembers = this.clusterInstance.getCluster().getMembers();
            for (Member currentMember : currentMembers) {
                MemberId memberId = this.getMemberId(currentMember);
                GL.trace((String)"ha", (String)"      member: {}", (Object[])new Object[]{memberId});
            }
        }
    }

    private void logBalancerMap() {
        GL.trace((String)"ha", (String)"Current members of balancer map:", (Object[])new Object[0]);
        IMap memberIdBalancerUriMap = this.getCollectionsFactory().getMap("memberIdBalancerMap");
        for (MemberId memberID : memberIdBalancerUriMap.keySet()) {
            GL.trace((String)"ha", (String)" MemberID {}", (Object[])new Object[]{memberID});
            Map balanceURIMap = (Map)memberIdBalancerUriMap.get(memberID);
            for (String balanceURI : balanceURIMap.keySet()) {
                List balanceTargets = (List)balanceURIMap.get(balanceURI);
                GL.trace((String)"ha", (String)"     balance URI: {}    target list: {}", (Object[])new Object[]{balanceURI, balanceTargets});
            }
        }
        GL.trace((String)"ha", (String)"Current shared balancer map::", (Object[])new Object[0]);
        IMap balancerMap = this.getCollectionsFactory().getMap("balancerMap");
        for (String balanceURI : balancerMap.keySet()) {
            Set balanceTargets = (Set)balancerMap.get(balanceURI);
            GL.trace((String)"ha", (String)"     balance URI: {}    target list: {}", (Object[])new Object[]{balanceURI, balanceTargets});
        }
    }

    private void fireMemberAdded(MemberId newMember) {
        GL.debug((String)"ha", (String)"Firing member added for : {}", (Object[])new Object[]{newMember});
        for (MembershipEventListener listener : this.membershipEventListeners) {
            try {
                listener.memberAdded(newMember);
            }
            catch (Throwable e) {
                GL.error((String)"ha", (String)"Error in member added event {}", (Object[])new Object[]{e});
            }
        }
    }

    private void fireMemberRemoved(MemberId exMember) {
        GL.debug((String)"ha", (String)"Firing member removed for: {}", (Object[])new Object[]{exMember});
        for (MembershipEventListener listener : this.membershipEventListeners) {
            try {
                listener.memberRemoved(exMember);
            }
            catch (Throwable e) {
                GL.error((String)"ha", (String)"Error in member removed event {}", (Object[])new Object[]{e});
            }
        }
    }

    private void fireInstanceKeyAdded(String instanceKey) {
        GL.debug((String)"ha", (String)"Firing instanceKeyAdded for: {}", (Object[])new Object[]{instanceKey});
        for (InstanceKeyListener listener : this.instanceKeyListeners) {
            try {
                listener.instanceKeyAdded(instanceKey);
            }
            catch (Throwable e) {
                GL.error((String)"ha", (String)"Error in instanceKeyAdded event {}", (Object[])new Object[]{e});
            }
        }
    }

    private void fireInstanceKeyRemoved(String instanceKey) {
        GL.debug((String)"ha", (String)"Firing instanceKeyRemoved for: {}", (Object[])new Object[]{instanceKey});
        for (InstanceKeyListener listener : this.instanceKeyListeners) {
            try {
                listener.instanceKeyRemoved(instanceKey);
            }
            catch (Throwable e) {
                GL.error((String)"ha", (String)"Error in instanceKeyRemoved event {}", (Object[])new Object[]{e});
            }
        }
    }

    private void fireBalancerEntryAdded(EntryEvent<String, Collection<String>> entryEvent) {
        String balancerURI = (String)entryEvent.getKey();
        GL.debug((String)"ha", (String)"Firing balancerEntryAdded for: {}", (Object[])new Object[]{balancerURI});
        for (BalancerMapListener listener : this.balancerMapListeners) {
            try {
                listener.balancerEntryAdded(balancerURI, (Collection)entryEvent.getValue());
            }
            catch (Throwable e) {
                GL.error((String)"ha", (String)"Error in balancerEntryAdded event {}", (Object[])new Object[]{e});
            }
        }
    }

    private void fireBalancerEntryRemoved(EntryEvent<String, Collection<String>> entryEvent) {
        String balancerURI = (String)entryEvent.getKey();
        GL.debug((String)"ha", (String)"Firing balancerEntryRemoved for: {}", (Object[])new Object[]{balancerURI});
        for (BalancerMapListener listener : this.balancerMapListeners) {
            try {
                listener.balancerEntryRemoved(balancerURI, (Collection)entryEvent.getValue());
            }
            catch (Throwable e) {
                GL.error((String)"ha", (String)"Error in balancerEntryRemoved event {}", (Object[])new Object[]{e});
            }
        }
    }

    private void fireBalancerEntryUpdated(EntryEvent<String, Collection<String>> entryEvent) {
        String balancerURI = (String)entryEvent.getKey();
        GL.debug((String)"ha", (String)"Firing balancerEntryUpdated for: {}", (Object[])new Object[]{balancerURI});
        for (BalancerMapListener listener : this.balancerMapListeners) {
            try {
                listener.balancerEntryUpdated(balancerURI, (Collection)entryEvent.getValue());
            }
            catch (Throwable e) {
                GL.error((String)"ha", (String)"Error in balancerEntryUpdated event {}", (Object[])new Object[]{e});
            }
        }
    }

    public CollectionsFactory getCollectionsFactory() {
        this.initializeCluster(null);
        return this.collectionsFactory;
    }

    private void initializeCluster(Config config) {
        if (this.clusterInitialized.compareAndSet(false, true)) {
            this.clusterInstance = Hazelcast.newHazelcastInstance((Config)config);
            if (this.clusterInstance == null) {
                throw new RuntimeException("Unable to initialize the cluster");
            }
            Cluster cluster = this.clusterInstance.getCluster();
            cluster.addMembershipListener(this.membershipListener);
            LoggingService loggingService = this.clusterInstance.getLoggingService();
            loggingService.addLogListener(Level.FINEST, (LogListener)this);
            this.collectionsFactory = new ClusterCollectionsFactory(this.clusterInstance);
            this.messageBufferFactory = new ClusterMemoryMessageBufferFactory(this.clusterInstance);
            this.localNodeId = this.getMemberId(cluster.getLocalMember());
            this.clusterMessaging = new ClusterMessaging((ClusterContext)this, this.clusterInstance, this.schedulerProvider);
            IMap instanceKeyMap = this.collectionsFactory.getMap(INSTANCE_KEY_MAP);
            instanceKeyMap.put((Object)this.localNodeId, (Object)this.localInstanceKey);
            instanceKeyMap.addEntryListener(this.instanceKeyEntryListener, true);
            IMap balancerMap = this.collectionsFactory.getMap("balancerMap");
            balancerMap.addEntryListener(this.balancerMapEntryListener, true);
        }
    }

    public void log(LogEvent logEvent) {
        Member member = logEvent.getMember();
        LogRecord record = logEvent.getLogRecord();
        Level level = record.getLevel();
        if (level.equals(Level.SEVERE)) {
            this.logger.error(String.format(CLUSTER_LOG_FORMAT, member, record.getMessage()));
        } else if (level.equals(Level.WARNING)) {
            this.logger.warn(String.format(CLUSTER_LOG_FORMAT, member, record.getMessage()));
        } else if (level.equals(Level.INFO)) {
            this.logger.info(String.format(CLUSTER_LOG_FORMAT, member, record.getMessage()));
        } else if (level.equals(Level.FINE)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format(CLUSTER_LOG_FORMAT, member, record.getMessage()));
            }
        } else if ((level.equals(Level.FINER) || level.equals(Level.FINEST)) && this.logger.isTraceEnabled()) {
            this.logger.trace(String.format(CLUSTER_LOG_FORMAT, member, record.getMessage()));
        }
    }
}

