/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server;

import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.kaazing.gateway.server.Gateway;
import org.kaazing.gateway.server.GatewayFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayCommandLineProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayCommandLineProcessor.class);
    private HelpFormatter helpFormatter;

    protected GatewayCommandLineProcessor(HelpFormatter helpFormatter) {
        this.helpFormatter = helpFormatter;
    }

    public void launchGateway(String[] args) {
        this.launchGateway(args, System.getProperties());
    }

    private void launchGateway(String[] args, Properties properties) {
        CommandLine cmd = null;
        Options options = this.createOptions();
        try {
            PosixParser parser = new PosixParser();
            cmd = parser.parse(options, args);
        }
        catch (ParseException ex) {
            this.printCliHelp("There was a problem with a command-line argument:\n" + ex.getMessage(), options);
            return;
        }
        String[] nonProcessedArgs = cmd.getArgs();
        if (nonProcessedArgs != null && nonProcessedArgs.length > 0) {
            System.out.println("There was a problem with the command-line arguments.");
            System.out.println("One or more unknown arguments were not processed:");
            for (String nonProcessedArg : nonProcessedArgs) {
                System.out.println("   " + nonProcessedArg);
            }
            this.printCliHelp(null, options);
            return;
        }
        if (cmd.hasOption("help")) {
            this.printCliHelp(null, options);
            return;
        }
        String config = cmd.getOptionValue("config");
        if (config != null) {
            properties.setProperty("GATEWAY_CONFIG", config);
        }
        final Gateway gateway = GatewayFactory.createGateway();
        gateway.setProperties(properties);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    gateway.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            gateway.launch();
        }
        catch (Exception ex) {
            LOGGER.error("Gateway failed to launch", (Throwable)ex);
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private void printCliHelp(String message, Options options) {
        if (message != null) {
            System.out.println(message);
        }
        this.helpFormatter.printHelp("gateway.start", options, true);
    }

    private Options createOptions() {
        Options options = new Options();
        options.addOption(null, "config", true, "path to gateway configuration file");
        options.addOption(null, "help", false, "print the help text");
        return options;
    }
}

