/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.context.resolve;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.kaazing.gateway.security.RealmContext;
import org.kaazing.gateway.server.context.GatewayContext;
import org.kaazing.gateway.server.context.SchemeContext;
import org.kaazing.gateway.server.context.ServiceDefaultsContext;
import org.kaazing.gateway.server.context.TransportContext;
import org.kaazing.gateway.server.context.resolve.DefaultSchemeContext;
import org.kaazing.gateway.server.context.resolve.DefaultTransportContext;
import org.kaazing.gateway.server.context.resolve.RealmsContext;
import org.kaazing.gateway.server.service.ServiceRegistry;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.util.scheduler.SchedulerProvider;

public class DefaultGatewayContext
implements GatewayContext {
    private final ClusterContext cluster;
    private final Map<String, DefaultSchemeContext> schemes;
    private final Map<String, DefaultTransportContext> schemeTransports;
    private final RealmsContext realms;
    private final ServiceRegistry servicesByURI;
    private final Collection<ServiceContext> services;
    private final File webDir;
    private final File tempDir;
    private final SchedulerProvider schedulerProvider;
    private final ServiceDefaultsContext serviceDefaults;
    private final Map<String, Object> injectables = new HashMap<String, Object>();

    public DefaultGatewayContext(Map<String, DefaultSchemeContext> schemes, Map<String, DefaultTransportContext> schemeTransports, RealmsContext realms, ServiceDefaultsContext serviceDefaults, Collection<ServiceContext> services, ServiceRegistry servicesByURI, File webDir, File tempDir, ClusterContext cluster, SchedulerProvider schedulerProvider) {
        this.schemes = schemes;
        this.schemeTransports = schemeTransports;
        this.realms = realms;
        this.serviceDefaults = serviceDefaults;
        this.services = services;
        this.servicesByURI = servicesByURI;
        this.webDir = webDir;
        this.tempDir = tempDir;
        this.cluster = cluster;
        this.schedulerProvider = schedulerProvider;
    }

    public Collection<ServiceContext> getServices() {
        return this.services;
    }

    @Override
    public DefaultSchemeContext getScheme(String name) {
        return this.schemes.get(name);
    }

    @Override
    public DefaultTransportContext getTransportForScheme(String schemeName) {
        return this.schemeTransports.get(schemeName);
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.servicesByURI;
    }

    @Override
    public RealmContext getRealm(String name) {
        return this.realms.getRealmContext(name);
    }

    @Override
    public Collection<? extends RealmContext> getRealms() {
        return this.realms.getRealms();
    }

    @Override
    public void dispose() {
        HashSet<DefaultTransportContext> transports = new HashSet<DefaultTransportContext>();
        for (SchemeContext schemeContext : this.schemes.values()) {
            DefaultTransportContext transport = this.getTransportForScheme(schemeContext.getName());
            if (transport == null) continue;
            transports.add(transport);
        }
        for (TransportContext transportContext : transports) {
            transportContext.dispose();
        }
        this.cluster.dispose();
        this.schedulerProvider.shutdownNow();
    }

    @Override
    public File getTempDirectory() {
        return this.tempDir;
    }

    public File getWebDirectory() {
        return this.webDir;
    }

    @Override
    public ClusterContext getCluster() {
        return this.cluster;
    }

    @Override
    public ServiceDefaultsContext getServiceDefaults() {
        return this.serviceDefaults;
    }

    @Override
    public Map<String, Object> getInjectables() {
        return this.injectables;
    }
}

