/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.test.config.builder;

import java.io.File;
import java.security.KeyStore;
import java.util.Set;
import org.kaazing.gateway.server.test.config.RealmConfiguration;
import org.kaazing.gateway.server.test.config.SecurityConfiguration;
import org.kaazing.gateway.server.test.config.Suppressible;
import org.kaazing.gateway.server.test.config.SuppressibleConfiguration;
import org.kaazing.gateway.server.test.config.builder.AbstractConfigurationBuilder;
import org.kaazing.gateway.server.test.config.builder.AbstractRealmConfigurationBuilder;

public abstract class AbstractSecurityConfigurationBuilder<R>
extends AbstractConfigurationBuilder<SecurityConfiguration, R> {
    public AbstractSecurityConfigurationBuilder<R> keyStore(KeyStore keyStore) {
        ((SecurityConfiguration)this.configuration).getSuppressibleConfiguration().setKeyStore(new Suppressible<KeyStore>(keyStore, this.getCurrentSuppressions()));
        return this;
    }

    @Deprecated
    public AbstractSecurityConfigurationBuilder<R> keyStoreFile(String keyStoreFile) {
        ((SecurityConfiguration)this.configuration).setKeyStoreFile(keyStoreFile);
        return this;
    }

    @Deprecated
    public AbstractSecurityConfigurationBuilder<R> trustStoreFile(String trustStoreFile) {
        ((SecurityConfiguration)this.configuration).setTrustStoreFile(trustStoreFile);
        return this;
    }

    public AbstractSecurityConfigurationBuilder<R> keyStorePassword(char[] keyStorePassword) {
        ((SecurityConfiguration)this.configuration).setKeyStorePassword(keyStorePassword);
        return this;
    }

    public AbstractSecurityConfigurationBuilder<R> trustStorePassword(char[] trustStorePassword) {
        ((SecurityConfiguration)this.configuration).setTrustStorePassword(trustStorePassword);
        return this;
    }

    @Deprecated
    public AbstractSecurityConfigurationBuilder<R> keyStorePasswordFile(File keyStorePasswordFile) {
        ((SecurityConfiguration)this.configuration).setKeyStorePasswordFile(keyStorePasswordFile.getAbsolutePath());
        return this;
    }

    @Deprecated
    public AbstractSecurityConfigurationBuilder<R> trustStorePasswordFile(File trustStorePasswordFile) {
        ((SecurityConfiguration)this.configuration).setTrustStorePasswordFile(trustStorePasswordFile.getAbsolutePath());
        return this;
    }

    public AbstractSecurityConfigurationBuilder<R> trustStore(KeyStore trustStore) {
        ((SecurityConfiguration)this.configuration).getSuppressibleConfiguration().setTrustStore(new Suppressible<KeyStore>(trustStore, this.getCurrentSuppressions()));
        return this;
    }

    public abstract AbstractRealmConfigurationBuilder<? extends AbstractSecurityConfigurationBuilder<R>> realm();

    public AbstractSecurityConfigurationBuilder(SecurityConfiguration configuration, R result, Set<SuppressibleConfiguration.Suppression> suppressions) {
        super(configuration, result, suppressions);
    }

    public AbstractSecurityConfigurationBuilder<R> suppress(SuppressibleConfiguration.Suppression ... suppressions) {
        super.addCurrentSuppressions(suppressions);
        return this;
    }

    public static class AddRealmBuilder<R extends AbstractSecurityConfigurationBuilder<?>>
    extends AbstractRealmConfigurationBuilder<R> {
        public AddRealmBuilder(R result, Set<SuppressibleConfiguration.Suppression> suppressions) {
            super(new RealmConfiguration(), result, suppressions);
        }

        @Override
        public AbstractRealmConfigurationBuilder.AddLoginModuleBuilder<AddRealmBuilder<R>> loginModule() {
            return new AbstractRealmConfigurationBuilder.AddLoginModuleBuilder<AddRealmBuilder<R>>(this, this.getCurrentSuppressions());
        }

        @Override
        public R done() {
            ((SecurityConfiguration)((AbstractSecurityConfigurationBuilder)this.result).configuration).getRealms().add((RealmConfiguration)this.configuration);
            return (R)((AbstractSecurityConfigurationBuilder)super.done());
        }
    }
}

